/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.multithread.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;

public class CalledBackendTracer
extends BlamePointTracer
implements KConstants {
    public CalledBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected void doFinishBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        if (TibcoBWUtils.isMBBSEnabled() && TibcoBWUtils.isTibcoEngineThread()) {
            boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
            String frontend = (String)data.get("com.wily.soaextension.frontend.name");
            if (frontend != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(frontend);
                sb.append("|Called Backends|");
                sb.append(component);
                component = sb.toString();
                super.doFinishBlamePointTrace(tracerIndex, data, component);
                if (isDebugEnabled) {
                    StringBuilder debugMsg = new StringBuilder();
                    debugMsg.append("CalledBackendTracer::doFinishBlamePointTrace,Frontend: ");
                    debugMsg.append(frontend);
                    debugMsg.append(" , Backend: ");
                    debugMsg.append(component);
                    debugMsg.append(" , Thread: ");
                    debugMsg.append(Thread.currentThread().getName());
                    TibcoBWUtils.getLogger().debug(debugMsg.toString());
                }
            } else if (isDebugEnabled) {
                StringBuilder debugMsg = new StringBuilder();
                debugMsg.append("CalledBackendTracer::doFinishBlamePointTrace,Frontend: Not Available , Backend: ");
                debugMsg.append(component);
                debugMsg.append(" , Thread: ");
                debugMsg.append(Thread.currentThread().getName());
                TibcoBWUtils.getLogger().debug(debugMsg.toString());
            }
        }
    }

    protected void doStartBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        String backendComponent = component;
        if (TibcoBWUtils.isTibcoEngineThread() && TibcoBWUtils.isMBBSEnabled()) {
            boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
            String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
            MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
            String frontend = blameStackFeature.getCollector().getFrontend(correlationId);
            if (frontend != null) {
                data.put("com.wily.soaextension.frontend.name", (Object)frontend);
                StringBuilder sb = new StringBuilder();
                sb.append(frontend);
                sb.append("|Called Backends|");
                sb.append(component);
                component = sb.toString();
                super.doStartBlamePointTrace(tracerIndex, data, component);
                if (isDebugEnabled) {
                    StringBuilder debugMsg = new StringBuilder();
                    debugMsg.append("CalledBackendTracer::doStartBlamePointTrace,Frontend: ");
                    debugMsg.append(frontend);
                    debugMsg.append(" , Backend: ");
                    debugMsg.append(component);
                    debugMsg.append(" ,CorrelationID: ");
                    debugMsg.append(correlationId);
                    debugMsg.append(" , Thread: ");
                    debugMsg.append(Thread.currentThread().getName());
                    TibcoBWUtils.getLogger().debug(debugMsg.toString());
                }
            } else {
                if (blameStackFeature.getCollector().getFrontendErrorCount() < 1) {
                    TibcoBWUtils.getLogger().warn("No Frontend available for Backend: " + backendComponent);
                }
                blameStackFeature.getCollector().noteFrontendError();
                if (isDebugEnabled) {
                    StringBuilder debugMsg = new StringBuilder();
                    debugMsg.append("CalledBackendTracer::doStartBlamePointTrace,Frontend: Not Available , Backend: ");
                    debugMsg.append(component);
                    debugMsg.append(" ,CorrelationID: ");
                    debugMsg.append(correlationId);
                    debugMsg.append(" , Thread: ");
                    debugMsg.append(Thread.currentThread().getName());
                    TibcoBWUtils.getLogger().debug(debugMsg.toString());
                }
            }
        }
    }

    protected void addComponentToBlameStack(String component, InvocationData data) {
    }

    protected void removeComponentFromBlameStack(String component, InvocationData data) {
    }

    protected IIntegerAggregatingDataAccumulator createTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }
}

