/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.classfile.InvalidPackageNameException;
import com.wily.util.classfile.java.ClassFileValidationUtilities;
import com.wily.util.classfile.java.PackageName;
import com.wily.util.text.FormattedLocalizableMessage;

public final class ClassName
implements IClassName {
    private final PackageName fPackage;
    private final String fClassName;
    private final String fFullyQualifiedDotSeparatedClassName;
    private final String fFullyQualifiedSlashSeparatedClassName;

    private ClassName(PackageName pkg, String className) {
        this.fPackage = pkg;
        this.fClassName = className;
        this.fFullyQualifiedDotSeparatedClassName = this.calculateDotSeparatedClassName();
        this.fFullyQualifiedSlashSeparatedClassName = this.calculateSlashSeparatedClassName();
    }

    private String calculateDotSeparatedClassName() {
        if (this.fPackage != null && !this.fPackage.isDefaultPackage()) {
            return String.valueOf(this.fPackage.getDotSeparatedName()) + "." + this.fClassName;
        }
        return this.fClassName;
    }

    private String calculateSlashSeparatedClassName() {
        if (this.fPackage != null && !this.fPackage.isDefaultPackage()) {
            return String.valueOf(this.fPackage.toString()) + "/" + this.fClassName;
        }
        return this.fClassName;
    }

    public boolean hasContainerName() {
        return false;
    }

    public IContainerName getContainerName() {
        return null;
    }

    public IPackageName getPackageName() {
        return this.getPackage();
    }

    public String getNameString() {
        return this.fClassName;
    }

    public String getPackageAndNameString() {
        return this.fFullyQualifiedSlashSeparatedClassName;
    }

    public String getContainerAndPackageAndNameString() {
        return this.getPackageAndNameString();
    }

    public PackageName getPackage() {
        return this.fPackage;
    }

    public String getReflectionFriendlyQualifiedNameString() {
        return this.fFullyQualifiedDotSeparatedClassName;
    }

    public String toString() {
        return this.getPackageAndNameString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassName) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean looselyMatches(IClassName candidate) {
        ClassName other = (ClassName)candidate;
        return this.getPackageAndNameString().equals(other.getPackageAndNameString());
    }

    public static ClassName getClassName(String className) throws InvalidClassNameException {
        String normalizedName = className == null ? "" : className.replace('.', '/');
        return ClassName.parseSlashSeparatedClassName(normalizedName);
    }

    private static ClassName parseSlashSeparatedClassName(String name) throws InvalidClassNameException {
        try {
            String packageName = null;
            String className = name;
            int separatorIndex = name.lastIndexOf(47);
            if (separatorIndex != -1) {
                packageName = name.substring(0, separatorIndex);
                className = name.substring(separatorIndex + 1);
            }
            PackageName pkg = PackageName.getPackageName(packageName);
            ClassFileValidationUtilities.validateSimpleJavaIdentifier(className);
            return new ClassName(pkg, className);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            throw new InvalidClassNameException(new FormattedLocalizableMessage("Class_File_Invalid_Class_Name", name), name);
        }
        catch (InvalidPackageNameException invalidPackageNameException) {
            throw new InvalidClassNameException(new FormattedLocalizableMessage("Class_File_Invalid_Class_Name", name), name);
        }
    }
}

