/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarExtension;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public class JarExtensionProxy
implements IExtensionProxy {
    private final ExtendedFile fTargetFile;
    private final JarURLPhysicalModule fJarModule;
    private final String fName;
    private List fDependencies;
    private String fType;
    private int fRank;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarExtensionProxy(ExtendedFile targetFile, boolean loadEclipsePluginsIfPossible) throws InvalidExtensionException {
        super();
        this.fTargetFile = targetFile;
        try {
            this.fJarModule = new JarURLPhysicalModule(this.fTargetFile.toURL());
        }
        catch (IOException e) {
            throw new InvalidExtensionException("Invalid jar file", e, new FormattedLocalizableMessage("Extension_Invalid_Jar_File_Message", new String[]{this.fTargetFile.getAbsolutePath()}));
        }
        name = null;
        try {
            block12: {
                block13: {
                    try {
                        name = this.getMainAttributeValueorThrow("com-wily-Extension-Name");
                        ** GOTO lbl-1000
                    }
                    catch (InvalidExtensionException e) {
                        if (!loadEclipsePluginsIfPossible) break block12;
                        bundleName = this.getMainAttributes().getValue("Bundle-SymbolicName");
                        if (bundleName == null) {
                            bundleName = this.getMainAttributes().getValue("Bundle-Name");
                        }
                        if (bundleName == null) break block12;
                        index = bundleName.indexOf(59);
                        if (index > 0) {
                            bundleName = bundleName.substring(0, index);
                        }
                        name = bundleName;
                        dependencies = this.getMainAttributes().getValue("Require-Bundle");
                        if (dependencies == null) {
                            this.fDependencies = Collections.EMPTY_LIST;
                            break block13;
                        }
                        this.fDependencies = new ArrayList<E>();
                        tokenizer = new StringTokenizer(dependencies, ",");
                    }
                    while (tokenizer.hasMoreElements()) {
                        dependency = tokenizer.nextToken();
                        index = dependency.indexOf(59);
                        if (index > 0) {
                            dependency = dependency.substring(0, index);
                        }
                        this.fDependencies.add(dependency);
                    }
                }
                this.fType = "Eclipse-Plugin";
                var10_13 = null;
                this.fName = name;
                return;
            }
            throw e;
        }
        catch (Throwable var11_16) {
            var10_14 = null;
            this.fName = name;
            throw var11_16;
        }
lbl-1000:
        // 1 sources

        {
            var10_15 = null;
            this.fName = name;
            commaSeparatedDependencies = this.getMainAttributeValue("com-wily-Extension-depends-on");
            deps = commaSeparatedDependencies == null ? new String[]{} : StringUtils.parseAndTrimList(commaSeparatedDependencies, ",");
        }
        this.fDependencies = Arrays.asList(deps);
        this.fType = this.getMainAttributeValue("com-wily-Extension-Type");
    }

    public String IExtensionProxy_getName() {
        return this.fName;
    }

    public String[] IExtensionProxy_getDependencies() {
        return this.fDependencies.toArray(new String[0]);
    }

    public String IExtensionProxy_getType() {
        return this.fType;
    }

    public IExtension IExtensionProxy_newInstance(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws InvalidExtensionException {
        JarExtension extension = new JarExtension(this.fName, this.IExtensionProxy_getDependencies(), feedback, this.fTargetFile);
        extension.IExtension_setParentClassLoader(parentClassLoader);
        return extension;
    }

    Attributes getMainAttributes() {
        return this.fJarModule.getManifest().getMainAttributes();
    }

    private String getMainAttributeValueorThrow(String key) throws InvalidExtensionException {
        String value = this.getMainAttributes().getValue(key);
        if (value == null) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Missing_Required_Manifest_Attribute_Message", new String[]{this.fName, this.fTargetFile.getAbsolutePath(), key}));
        }
        return value;
    }

    String getMainAttributeValue(String key) {
        String value = this.getMainAttributes().getValue(key);
        return StringUtils.trim(value);
    }

    public boolean equals(Object obj) {
        JarExtensionProxy other = (JarExtensionProxy)obj;
        return other.IExtensionProxy_getName().equals(this.fName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Jar File Extension -");
        sb.append(this.fName);
        sb.append("Located at -");
        sb.append(this.fTargetFile.getAbsolutePath());
        return sb.toString();
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public String ITopologicalSortNode_getId() {
        return this.IExtensionProxy_getName();
    }

    public String[] ITopologicalSort_getDependencies() {
        return this.IExtensionProxy_getDependencies();
    }

    public int ITopologicalSort_getRank() {
        return this.fRank;
    }

    public void ITopologicalSort_setRank(int v) {
        this.fRank = v;
    }
}

