/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.probe.net.ManagedSocketMapHelper;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.hc2.AppMapApplicationNameTracer;
import com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SafeFeedbackWrapper;
import java.util.Stack;

public abstract class AppMapReplayer {
    private static final Module kModule = new Module("AppMapReplayer");
    private static final IModuleFeedbackChannel fFeedback;
    static /* synthetic */ Class class$0;

    static {
        SafeFeedbackWrapper workFeedback = null;
        try {
            IModuleFeedbackChannel nativeFeedback;
            IAgent agent = AgentShim.getAgent();
            if (agent != null && (nativeFeedback = AgentShim.getAgent().IAgent_getModuleFeedback()) != null) {
                SafeFeedbackWrapper wrapped;
                workFeedback = wrapped = new SafeFeedbackWrapper(nativeFeedback, agent.IAgent_getGuaranteedCounter(), 20){

                    public void doOnMaxError(int kMaxReportedErrors) {
                    }
                };
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        fFeedback = workFeedback;
    }

    public abstract void executeAppMap(IAppMapStack var1);

    public void replayAppMapOnStack(IStackType type, InvocationData data, int tracerIndex) {
        block3: {
            try {
                this.replayAppMapOnStack(type, data, tracerIndex, false);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (fFeedback == null) break block3;
                fFeedback.error(kModule, "Error while replying app map " + t.getMessage());
                fFeedback.debug(kModule, "Error while replying app map", t);
            }
        }
    }

    public void replayAppMapOnStack(IStackType type, InvocationData data, int tracerIndex, boolean skipParentTracer) {
        block5: {
            try {
                if (data == null || data.isTransactionAborted()) {
                    return;
                }
                IAppMapStack stack = AppMapService.getStack(type);
                AppMapReplayerTracerCallback callback = AppMapReplayer.searchPreviousTracerAndExecute(type, stack, data, tracerIndex, skipParentTracer);
                this.executeAppMap(stack);
                if (callback != null) {
                    callback.shutdown();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (fFeedback == null) break block5;
                fFeedback.error(kModule, "Error while replying app map " + t.getMessage());
                fFeedback.debug(kModule, "Error while replying app map", t);
            }
        }
    }

    private static AppMapReplayerTracerCallback searchPreviousTracerAndExecuteOld(IStackType type, final IAppMapStack stack, InvocationData data, int tracerIndex) {
        AppMapReplayerTracerCallback result = null;
        InvocationData pivot = data;
        boolean isCurrentData = tracerIndex >= 0;
        while (pivot != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITracer[] tracers = pivot.getTracersByType((Class)clazz);
            int i = 0;
            while (i < (isCurrentData ? tracerIndex : tracers.length)) {
                IAppMapReplayerTracer previousAppMapTracer;
                if (tracers[i] != null && (previousAppMapTracer = (IAppMapReplayerTracer)tracers[i]).actsOnStack(type) && !previousAppMapTracer.isAppMapNameTracer()) {
                    AppMapReplayerTracerCallback appmapnamecallbacks = AppMapReplayer.doAppNamesReplay(data, type, stack);
                    if (previousAppMapTracer.replay_startTrace(i, pivot, stack)) {
                        final int j = i;
                        final InvocationData previousData = pivot;
                        final IAppMapReplayerTracer pt = previousAppMapTracer;
                        result = new AppMapReplayerTracerCallback(){

                            void doShutdown() {
                                pt.replay_shutdown(j, previousData, stack);
                            }
                        };
                        result.nextCallback = appmapnamecallbacks;
                        break;
                    }
                    if (appmapnamecallbacks != null) {
                        appmapnamecallbacks.shutdown();
                    }
                }
                ++i;
            }
            pivot = AppMapReplayer.getParent(pivot);
            isCurrentData = false;
        }
        if (result == null) {
            return AppMapReplayer.doAppNamesReplay(data, type, stack);
        }
        return result;
    }

    private static InvocationData getParent(InvocationData data) {
        int stackRecursionCounter = 0;
        InvocationData pivot = data;
        do {
            if ((pivot = pivot.getParent()) != null && pivot instanceof InvocationData) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (pivot.hasTraceFactoryClass((Class)clazz)) {
                    return pivot;
                }
            }
            if (stackRecursionCounter++ <= StackRecursionHelper.kMaxRecursive) continue;
            throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
        } while (pivot != null);
        return null;
    }

    private static InvocationData getAppMapParent(InvocationData data) {
        InvocationData pivot = data;
        do {
            if ((pivot = pivot.getAppMapParent()) == null) continue;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!pivot.hasTraceFactoryClass((Class)clazz)) continue;
            return pivot;
        } while (pivot != null);
        return null;
    }

    private static AppMapReplayerTracerCallback searchPreviousTracerAndExecute(IStackType type, final IAppMapStack stack, InvocationData data, int tracerIndex, boolean skipParentTracer) {
        if (skipParentTracer) {
            return AppMapReplayer.doAppNamesReplay(data, type, stack);
        }
        AppMapReplayerTracerCallback result = null;
        InvocationData pivot = data;
        boolean isCurrentData = tracerIndex >= 0;
        while (pivot != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITracer[] tracers = pivot.getTracersByType((Class)clazz);
            int i = 0;
            while (i < (isCurrentData ? tracerIndex : tracers.length)) {
                IAppMapReplayerTracer previousAppMapTracer;
                if (tracers[i] != null && (previousAppMapTracer = (IAppMapReplayerTracer)tracers[i]).actsOnStack(type) && !previousAppMapTracer.isAppMapNameTracer()) {
                    Stack reversedStack = AppMapReplayer.getReverseStackOnCursor(data);
                    InvocationData cursorForApplicationNameTracers = null;
                    AppMapReplayerTracerCallback appMapApplicationNameTracersCallback = null;
                    while (!reversedStack.empty()) {
                        cursorForApplicationNameTracers = (InvocationData)reversedStack.pop();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ITracer[] appMapReplayerTracers = cursorForApplicationNameTracers.getTracersByType((Class)clazz2);
                        int k = 0;
                        while (k < appMapReplayerTracers.length) {
                            IAppMapReplayerTracer appMapApplicationNameTracer;
                            if (cursorForApplicationNameTracers == pivot && k == i && result == null && previousAppMapTracer.replay_startTrace(i, pivot, stack)) {
                                final int j = i;
                                final InvocationData previousData = pivot;
                                final IAppMapReplayerTracer pt = previousAppMapTracer;
                                result = new AppMapReplayerTracerCallback(){

                                    void doShutdown() {
                                        pt.replay_shutdown(j, previousData, stack);
                                    }
                                };
                                if (appMapApplicationNameTracersCallback != null) {
                                    result.nextCallback = appMapApplicationNameTracersCallback;
                                }
                            }
                            if (appMapReplayerTracers[k] != null && (cursorForApplicationNameTracers != data || cursorForApplicationNameTracers == data && tracerIndex >= 0 && k < tracerIndex || cursorForApplicationNameTracers == data && tracerIndex < 0 && k < i) && (appMapApplicationNameTracer = (IAppMapReplayerTracer)appMapReplayerTracers[k]).actsOnStack(type) && appMapApplicationNameTracer.isAppMapNameTracer()) {
                                appMapApplicationNameTracer.replay_startTrace(k, cursorForApplicationNameTracers, stack);
                                final int finalIndex = k;
                                final InvocationData finalData = cursorForApplicationNameTracers;
                                final IAppMapReplayerTracer finalTracer = appMapApplicationNameTracer;
                                if (appMapApplicationNameTracersCallback == null) {
                                    appMapApplicationNameTracersCallback = new AppMapReplayerTracerCallback(){

                                        void doShutdown() {
                                            finalTracer.replay_shutdown(finalIndex, finalData, stack);
                                        }
                                    };
                                } else {
                                    appMapApplicationNameTracersCallback.nextCallback = new AppMapReplayerTracerCallback(){

                                        void doShutdown() {
                                            finalTracer.replay_shutdown(finalIndex, finalData, stack);
                                        }
                                    };
                                }
                            }
                            ++k;
                        }
                    }
                    if (result != null) break;
                    if (appMapApplicationNameTracersCallback != null) {
                        appMapApplicationNameTracersCallback.shutdown();
                    }
                }
                ++i;
            }
            if (result != null) break;
            pivot = AppMapReplayer.getParent(pivot);
            isCurrentData = false;
        }
        if (result == null) {
            return AppMapReplayer.doAppNamesReplay(data, type, stack);
        }
        return result;
    }

    private static AppMapReplayerTracerCallback doAppNamesReplay(InvocationData cursor, IStackType type, final IAppMapStack stack) {
        Stack reversedStack = AppMapReplayer.getReverseStackOnCursor(cursor);
        InvocationData cursorForApplicationNameTracers = null;
        AppMapReplayerTracerCallback appMapApplicationNameTracersCallback = null;
        while (!reversedStack.empty()) {
            cursorForApplicationNameTracers = (InvocationData)reversedStack.pop();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITracer[] appMapReplayerTracers = cursorForApplicationNameTracers.getTracersByType((Class)clazz);
            int k = 0;
            while (k < appMapReplayerTracers.length) {
                IAppMapReplayerTracer appMapApplicationNameTracer;
                if (appMapReplayerTracers[k] != null && (appMapApplicationNameTracer = (IAppMapReplayerTracer)appMapReplayerTracers[k]).actsOnStack(type) && appMapApplicationNameTracer.isAppMapNameTracer()) {
                    appMapApplicationNameTracer.replay_startTrace(k, cursorForApplicationNameTracers, stack);
                    final int finalIndex = k;
                    final InvocationData finalData = cursorForApplicationNameTracers;
                    final IAppMapReplayerTracer finalTracer = appMapApplicationNameTracer;
                    if (appMapApplicationNameTracersCallback == null) {
                        appMapApplicationNameTracersCallback = new AppMapReplayerTracerCallback(){

                            void doShutdown() {
                                finalTracer.replay_shutdown(finalIndex, finalData, stack);
                            }
                        };
                    } else {
                        appMapApplicationNameTracersCallback.nextCallback = new AppMapReplayerTracerCallback(){

                            void doShutdown() {
                                finalTracer.replay_shutdown(finalIndex, finalData, stack);
                            }
                        };
                    }
                }
                ++k;
            }
        }
        return appMapApplicationNameTracersCallback;
    }

    private static Stack getReverseStackOnCursor(InvocationData pivot) {
        Stack<InvocationData> reversedStack = new Stack<InvocationData>();
        while (pivot != null) {
            reversedStack.push(pivot);
            pivot = AppMapReplayer.getParent(pivot);
        }
        return reversedStack;
    }

    public static void replayForSockets(String ownerType, String level, InvocationData data, Integer tracerIndex, ManagedSocketMapHelper.ManagedSocketHelperReplayer executer) {
        block5: {
            try {
                if (data == null || data.isTransactionAborted()) {
                    return;
                }
                IStackType stackType = AppMapService.getStackType(level, ownerType);
                IAppMapStack stack = AppMapService.getStack(stackType);
                AppMapReplayerTracerCallback callback = AppMapReplayer.searchPreviousTracerAndExecute(stackType, stack, data, tracerIndex, false);
                executer.executeOnStack(stack);
                if (callback != null) {
                    callback.shutdown();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (fFeedback == null) break block5;
                fFeedback.error(kModule, "Error while replying app map " + t.getMessage());
                fFeedback.debug(kModule, "Error while replying app map", t);
            }
        }
    }

    public static void replayAppNamesCrossProcess(IAgent fAgent, SharedCrossProcessData cache) {
        block11: {
            try {
                InvocationData pivot = VirtualStack.peekAppMap();
                Stack<InvocationData> reversedStack = new Stack<InvocationData>();
                while (pivot != null) {
                    reversedStack.push(pivot);
                    pivot = AppMapReplayer.getAppMapParent(pivot);
                }
                if (!reversedStack.isEmpty()) {
                    AppMapApplicationNameTracer.pushAgentTriplet(fAgent, cache);
                }
                InvocationData data = null;
                while (!reversedStack.empty()) {
                    data = (InvocationData)reversedStack.pop();
                    data.ensureCrossProcessCache();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ITracer[] tracers = data.getTracersByType((Class)clazz);
                    int i = 0;
                    while (i < tracers.length) {
                        IAppMapReplayerTracer previousAppMapTracer;
                        if (tracers[i] != null && (previousAppMapTracer = (IAppMapReplayerTracer)tracers[i]).isAppMapNameTracer()) {
                            AppMapApplicationNameTracer tracer = (AppMapApplicationNameTracer)previousAppMapTracer;
                            tracer.replay_crossProcess(data, cache);
                        }
                        ++i;
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (fFeedback == null) break block11;
                fFeedback.error(kModule, "Error while replying app map " + t.getMessage());
                fFeedback.debug(kModule, "Error while replying app map", t);
            }
        }
    }

    static abstract class AppMapReplayerTracerCallback {
        AppMapReplayerTracerCallback nextCallback;

        AppMapReplayerTracerCallback() {
        }

        abstract void doShutdown();

        void shutdown() {
            this.doShutdown();
            if (this.nextCallback != null) {
                this.nextCallback.shutdown();
            }
        }
    }
}

