/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.KConstants;
import com.wily.org.apache.commons.httpclient.util.URIUtil;
import com.wily.util.feedback.Module;
import java.net.URI;

public class UrlUtilities {
    private static Module module = new Module("URL Utilities");

    public static String formatSpecialChars(String url) {
        if (url.indexOf(37) != -1 || url.indexOf(32) != -1) {
            StringBuilder bldr = UrlUtilities.replaceAllIllegalChars(new StringBuilder(url), KConstants.ILLEGAL_URI_CHARS, '_');
            return bldr.toString();
        }
        return url;
    }

    public static String encodeSpecialChars(IAgent agent, String url) {
        try {
            if (url.indexOf(124) != -1) {
                StringBuilder bldr = UrlUtilities.replaceAllIllegalChars(new StringBuilder(url), KConstants.ILLEGAL_METRIC_CHARS, '_');
                return URIUtil.encodePathQuery((String)bldr.toString());
            }
            return URIUtil.encodePathQuery((String)url);
        }
        catch (Exception ex) {
            agent.IAgent_getModuleFeedback().debug(module, "Unable to encode url" + url);
            agent.IAgent_getModuleFeedback().debug((Throwable)ex);
            return url;
        }
    }

    public static String decodeSpecialChars(String url) {
        try {
            return URIUtil.decode((String)url);
        }
        catch (Exception exception) {
            return url;
        }
    }

    public static StringBuilder replaceAllIllegalChars(StringBuilder builder, char[] illegalChars, char repChar) {
        if (builder != null && illegalChars != null) {
            String dest = String.valueOf(repChar);
            int i = 0;
            while (i < illegalChars.length) {
                String from = String.valueOf(illegalChars[i]);
                int index = builder.indexOf(from);
                while (index != -1) {
                    builder.replace(index, index + from.length(), dest);
                    index += dest.length();
                    index = builder.indexOf(from, index);
                }
                ++i;
            }
        }
        return builder;
    }

    public static String buildUrlString(URI uri, boolean withPort) {
        StringBuilder sb = new StringBuilder();
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme()).append(':');
        }
        if (uri.getHost() != null) {
            sb.append("//");
            sb.append(uri.getHost());
            if (withPort && uri.getPort() != -1) {
                sb.append(":").append(uri.getPort());
            }
        }
        if (uri.getRawPath() != null) {
            sb.append(uri.getRawPath());
        }
        return sb.toString();
    }
}

