/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeListing {
    public static final String kUseBlameAttribute = "useblame";
    public static final String kNewTracerAttribute = "newmode";
    public static final String kExternalSeparator = ",";
    private static final String kExternalSeparatorEncoded = "%2C";
    private static final String kEncodingChar = "%";
    private static final String kAttributeValueSeparator = "=";
    private static final String kAttributeValuePairSeparator = "&";
    private static final String kEncodingCharEncoded = "%25";
    private static final String kAttributeValueSeparatorEncoded = "%3D";
    private static final String kAttributeValuePairSeparatorEncoded = "%26";
    private static final String[] kUnencodedValues = new String[]{"%", "=", "&", ","};
    private static final String[] kEncodedValues = new String[]{"%25", "%3D", "%26", "%2C"};
    private final HashMap fAttributes = new HashMap();

    public AttributeListing() {
    }

    public AttributeListing(String attributes) {
        this();
        this.load(attributes);
    }

    public void put(String attribute, String value) {
        this.fAttributes.put(attribute, value);
    }

    public String get(String attribute) {
        return (String)this.fAttributes.get(attribute);
    }

    public void remove(String attribute) {
        this.fAttributes.remove(attribute);
    }

    public void clear() {
        this.fAttributes.clear();
    }

    public int size() {
        return this.fAttributes.size();
    }

    public boolean equals(Object o) {
        if (o instanceof AttributeListing) {
            AttributeListing listing = (AttributeListing)o;
            return this.fAttributes.equals(listing.fAttributes);
        }
        return false;
    }

    public int hashCode() {
        return this.fAttributes.hashCode();
    }

    public void load(Map map) {
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String attribute = (String)iterator.next();
                String value = (String)map.get(attribute);
                this.put(attribute, value);
            }
        }
    }

    public void load(String attributes) {
        this.fAttributes.clear();
        if (attributes != null) {
            int start = 0;
            int length = attributes.length();
            while (start < length) {
                int index = attributes.indexOf(kAttributeValueSeparator, start);
                if (index == -1) break;
                String name = attributes.substring(start, index);
                start = index + kAttributeValueSeparator.length();
                if ((index = attributes.indexOf(kAttributeValuePairSeparator, start)) == -1) {
                    index = length;
                }
                String value = attributes.substring(start, index);
                start = index + kAttributeValuePairSeparator.length();
                this.put(AttributeListing.decode(name), AttributeListing.decode(value));
            }
        }
    }

    public String save() {
        StringBuffer result = new StringBuffer();
        boolean firstElement = true;
        ArrayList list = new ArrayList(this.fAttributes.keySet());
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!firstElement) {
                result.append(kAttributeValuePairSeparator);
            }
            String attribute = (String)iterator.next();
            String value = (String)this.fAttributes.get(attribute);
            result.append(AttributeListing.encode(attribute));
            result.append(kAttributeValueSeparator);
            result.append(AttributeListing.encode(value));
            firstElement = false;
        }
        return result.toString();
    }

    public Iterator getKeys() {
        return this.fAttributes.keySet().iterator();
    }

    public void debug_show() {
        System.out.println("There are " + this.fAttributes.size() + " pairs:");
        Iterator iterator = this.fAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            String value = (String)this.fAttributes.get(attribute);
            System.out.println("\t[" + attribute + "] = [" + value + "]");
        }
    }

    private static String encode(String source) {
        return StringUtils.multipleReplace(source, kUnencodedValues, kEncodedValues);
    }

    private static String decode(String source) {
        return StringUtils.multipleReplace(source, kEncodedValues, kUnencodedValues);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.fAttributes;
    }
}

