/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.rules;

import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleChain;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RulesExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.rules.AbstractRule;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class AndRule
extends AbstractRule {
    private List<Rule> ruleset = new CopyOnWriteArrayList<Rule>();
    private Iterator<Rule> rulesIter = null;
    private boolean result = true;

    public AndRule(Rule rule1, Rule rule2) {
        this.ruleset.add(rule1);
        this.ruleset.add(rule2);
    }

    public AndRule(Set<Rule> rules) {
        this.ruleset.addAll(rules);
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        this.rulesIter = this.ruleset.iterator();
        RuleChain chain = new RuleChain(){

            public void doExecuteNextRule(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                Rule nextRule;
                boolean passed = false;
                RulesExecutionStatus sts = null;
                if (AndRule.this.result && (nextRule = this.getNextRuleInChain()) != null) {
                    sts = new RulesExecutionStatus(status.getMaxInitialCandidates(), status.getInitialCandidatesCount());
                    nextRule.execute(currentElementIndex, trace, (ExecutionStatus)sts, (RuleChain)this);
                    passed = sts.isMarkedAsCandidate();
                    AndRule.this.result = AndRule.this.result && passed;
                }
            }

            protected Rule getNextRuleInChain() {
                Rule nextRule = null;
                if (AndRule.this.rulesIter.hasNext()) {
                    nextRule = (Rule)AndRule.this.rulesIter.next();
                }
                return nextRule;
            }
        };
        chain.doExecuteNextRule(currentElementIndex, trace, status);
        return this.result;
    }

    public void addRule(Rule rule) {
        this.ruleset.add(rule);
    }
}

