/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.rules;

import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.rules.AbstractFailFastRule;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SkipPackageRule
extends AbstractFailFastRule {
    private Set<Pattern> packagePatterns = new HashSet<Pattern>();

    public SkipPackageRule(String packageNameExpr) {
        this(packageNameExpr, true);
    }

    public SkipPackageRule(String packageName, boolean isRegex) {
        String regex = packageName;
        if (!isRegex) {
            regex = Utils.convertToPackageRegex(packageName);
        }
        this.packagePatterns.add(Pattern.compile(regex, 2));
    }

    public SkipPackageRule(Set<String> packageExprsToSkip) {
        this(packageExprsToSkip, true);
    }

    public SkipPackageRule(Set<String> packagesToSkip, boolean isRegexBased) {
        this.addPackages(packagesToSkip, isRegexBased);
    }

    public final void addPackages(Set<String> packagesToSkip, boolean isRegexBased) {
        for (String packageExpr : packagesToSkip) {
            if (!isRegexBased) {
                packageExpr = Utils.convertToPackageRegex(packageExpr);
            }
            this.packagePatterns.add(Pattern.compile(packageExpr, 2));
        }
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = true;
        if (this.packagePatterns != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            passes = !Utils.doesElementPackageMatch(traceElement, this.packagePatterns);
        }
        return passes;
    }

    @Override
    public String toString() {
        return Utils.formatStringRep(String.valueOf(this.getClass().getSimpleName()) + ", packagePatterns:" + this.packagePatterns);
    }
}

