/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.CandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.TraceRecordingFilter;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.TraceRecordingListener;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;

public class ThreadSelector
implements TraceRecordingFilter,
TraceRecordingListener {
    private volatile int numberIntervalsToElapse = EntryPointDetectionConfiguration.getNumberIntervalsToElapse();

    private ThreadSelector() {
    }

    @Override
    public boolean shouldRecordTrace(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        int runNumber = CandidateFinder.currentRunNumber();
        return this.isQualifiedForRun(runNumber, threadLocalDeepStack.getRunSelectionId());
    }

    private boolean isQualifiedForRun(int runNumber, int runSelectionId) {
        return runSelectionId == 0 || runNumber >= runSelectionId;
    }

    @Override
    public void notifyOnRecording(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        threadLocalDeepStack.setRunSelectionId(CandidateFinder.currentRunNumber() + this.numberIntervalsToElapse);
    }

    public void setNumberIntervalsToElapse(int numberIntervalsToElapse) {
        this.numberIntervalsToElapse = numberIntervalsToElapse;
    }

    public void resetSelection(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        threadLocalDeepStack.setRunSelectionId(0);
    }

    public static ThreadSelector getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ ThreadSelector(ThreadSelector threadSelector) {
        this();
    }

    private static class SingletonHolder {
        private static final ThreadSelector INSTANCE = new ThreadSelector(null);

        private SingletonHolder() {
        }
    }
}

