/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.cmp.directives.apply.PersistenceFileLockHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.probebuilder.extension.instrument.intelligent.IntelligentInstrumentationService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationExtensionConstants;
import com.wily.introscope.probebuilder.intelligent.util.ClassMethodInfo;
import com.wily.introscope.probebuilder.intelligent.util.ClassUtil;
import com.wily.introscope.probebuilder.intelligent.util.MethodInfo;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.SeverityLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class FilePersistenceHelper
implements Runnable,
IDirectiveLoadListener {
    private IAgent fAgent;
    private boolean logPermissionMessageFlag;
    private boolean logInvalidPathMessageFlag;
    private static String retryTimeoutString;
    private static String retryAttemptsString;
    private HashMap<String, ClassMethodInfo> finalMethodListToWrite;
    private HashMap<String, ClassMethodInfo> filteredMethods;
    private static AtomicInteger instrumentedMethodsCountInPbd;
    private static AtomicInteger skippedMethodsCountInPbd;
    private int logBitMask = 0;
    private boolean agentStartFlag = false;
    private volatile boolean pbdStateChanged = false;

    static {
        instrumentedMethodsCountInPbd = new AtomicInteger(0);
        skippedMethodsCountInPbd = new AtomicInteger(0);
        retryTimeoutString = System.getProperty("introscope.agent.deep.persistence.retry.timeout");
        retryAttemptsString = System.getProperty("introscope.agent.deep.persistence.retry.attempts.writer");
    }

    public FilePersistenceHelper(IAgent Agent) {
        this.fAgent = Agent;
        this.logPermissionMessageFlag = false;
        this.logInvalidPathMessageFlag = false;
        this.finalMethodListToWrite = new HashMap();
        this.filteredMethods = new HashMap();
        this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().registerDirectiveLoadListener((IDirectiveLoadListener)this);
    }

    @Override
    public void run() {
        try {
            this.checkClampBitMasks();
            if (!PersistenceFileLockHelper.initializeSuccessful) {
                return;
            }
            if (this.filteredMethods.isEmpty()) {
                HashMap listToFilter = this.populateToPersistMethodsMap();
                if (!listToFilter.isEmpty()) {
                    listToFilter = ClassUtil.getJavaClassFromVM(listToFilter, false, this.fAgent);
                    this.filteredMethods = this.filterMethodsToPersist(listToFilter, true);
                }
            } else {
                this.filteredMethods = this.filterMethodsToPersist(this.filteredMethods, false);
            }
            if (!this.filteredMethods.isEmpty()) {
                instrumentedMethodsCountInPbd.set(0);
                skippedMethodsCountInPbd.set(0);
                this.persistToFile();
            } else {
                if (!this.agentStartFlag) {
                    instrumentedMethodsCountInPbd.set(0);
                    skippedMethodsCountInPbd.set(0);
                    this.readPbdAndCopy();
                    this.agentStartFlag = true;
                }
                if (this.pbdStateChanged) {
                    instrumentedMethodsCountInPbd.set(0);
                    skippedMethodsCountInPbd.set(0);
                    this.readPbdAndCopy();
                    this.pbdStateChanged = false;
                }
            }
            SustainabilityMetricsHelper.reportInstrumentedMethodsPersisted((int)FilePersistenceHelper.getInstrumentedMethodsCountInPbd());
            SustainabilityMetricsHelper.reportSkippedMethodsPersisted((int)FilePersistenceHelper.getSkippedMethodsCountInPbd());
        }
        catch (Exception e) {
            Logger.logException((String)"Unexpected exception in persistancy service ", (Exception)e);
        }
    }

    private void checkClampBitMasks() {
        int lockFileBitMask = 1;
        int traceClampBitMask = 2;
        int blackListClampBitMask = 4;
        int queueSizeClampBitMask = 8;
        int notPersistedBitMask = 16;
        if (!PersistenceFileLockHelper.initializeSuccessful) {
            PersistenceFileLockHelper.initialize((IAgent)this.fAgent);
            IntelligentInstrumentationService.setEntryPointBitMask(lockFileBitMask);
            return;
        }
        IntelligentInstrumentationService.clearEntryPointBitMask(lockFileBitMask);
        if (FilePersistenceHelper.getInstrumentedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize()) {
            IntelligentInstrumentationService.setEntryPointBitMask(traceClampBitMask);
            if ((this.logBitMask & traceClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry points will be discovered, because number of entry points has reached a clamp value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize() + ",  as defined in " + "introscope.agent.deep.entrypoint.count.max"));
                this.setLogBitMask(traceClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearEntryPointBitMask(traceClampBitMask);
            this.clearLogBitMask(traceClampBitMask);
        }
        if (FilePersistenceHelper.getSkippedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize()) {
            IntelligentInstrumentationService.setEntryPointBitMask(blackListClampBitMask);
            if ((this.logBitMask & blackListClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry points will be discovered, because Blacklist clamp introscope.agent.deep.entrypoint.blacklist.count.max reached max value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize()));
                this.setLogBitMask(blackListClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearEntryPointBitMask(blackListClampBitMask);
            this.clearLogBitMask(blackListClampBitMask);
        }
        if (FilePersistenceService.getQueueSize() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize()) {
            IntelligentInstrumentationService.setEntryPointBitMask(queueSizeClampBitMask);
            if ((this.logBitMask & queueSizeClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry points will be discovered, because persistence queue clamp introscope.agent.deep.persistence.queue.size reached max value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize()));
                this.setLogBitMask(queueSizeClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearEntryPointBitMask(queueSizeClampBitMask);
            this.clearLogBitMask(queueSizeClampBitMask);
        }
        if (!this.filteredMethods.isEmpty()) {
            IntelligentInstrumentationService.setEntryPointBitMask(notPersistedBitMask);
            if ((this.logBitMask & notPersistedBitMask) == 0) {
                Logger.logWarningMessage((String)"No new entry points will be discovered, because entry point persistence has failed");
                this.setLogBitMask(notPersistedBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearEntryPointBitMask(notPersistedBitMask);
            this.clearLogBitMask(notPersistedBitMask);
        }
    }

    private HashMap populateToPersistMethodsMap() {
        Set<String> keys = FilePersistenceService.getAllKeys();
        Iterator<String> it = keys.iterator();
        ClassName iclass = null;
        ArrayList<String> keysReadAlready = new ArrayList<String>();
        HashMap<String, ClassMethodInfo> listToPersist = new HashMap<String, ClassMethodInfo>();
        while (it.hasNext()) {
            String tempKey = it.next();
            String[] tempValue = FilePersistenceService.getValue(tempKey);
            keysReadAlready.add(tempKey);
            try {
                iclass = ClassName.getClassName((String)tempValue[0]);
                String className = iclass.getReflectionFriendlyQualifiedNameString();
                ClassMethodInfo cMInfo = (ClassMethodInfo)listToPersist.get(className);
                if (cMInfo == null) {
                    cMInfo = new ClassMethodInfo(className);
                    listToPersist.put(className, cMInfo);
                }
                cMInfo.addMethodWithDirectiveType(tempValue[1], tempValue[2], tempValue[3]);
            }
            catch (InvalidClassNameException e) {
                Logger.logException((String)"Could not get the class name.", (Exception)((Object)e));
            }
        }
        FilePersistenceService.clearEntries(keysReadAlready);
        return listToPersist;
    }

    private HashMap filterMethodsToPersist(HashMap<String, ClassMethodInfo> listToFilter, boolean shouldClear) {
        HashMap<String, ClassMethodInfo> skippedClassMethodMap = new HashMap<String, ClassMethodInfo>();
        HashMap instrumentedClassMethodMap = new HashMap();
        Set<String> keys = listToFilter.keySet();
        for (String className : keys) {
            ClassMethodInfo cmvg = listToFilter.get(className);
            Set k = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k) {
                ClassMethodInfo gapFiller;
                MethodInfo meth = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                String directiveType = meth.directiveType;
                if (directiveType.equalsIgnoreCase("skip")) {
                    gapFiller = skippedClassMethodMap.get(className);
                    if (gapFiller == null) {
                        gapFiller = new ClassMethodInfo(className);
                        skippedClassMethodMap.put(className, gapFiller);
                    }
                    gapFiller.addMethodWithDirectiveType(meth.methodName, meth.methodDesciptor, meth.directiveType);
                    continue;
                }
                if (!directiveType.equalsIgnoreCase("instrument")) continue;
                gapFiller = (ClassMethodInfo)instrumentedClassMethodMap.get(className);
                if (gapFiller == null) {
                    gapFiller = new ClassMethodInfo(className);
                    instrumentedClassMethodMap.put(className, gapFiller);
                }
                gapFiller.addMethodWithDirectiveType(meth.methodName, meth.methodDesciptor, meth.directiveType);
            }
        }
        instrumentedClassMethodMap = ClassUtil.getJavaClassFromVM(instrumentedClassMethodMap, false, this.fAgent);
        instrumentedClassMethodMap = ClassUtil.filterInstrumentedMethods(this.fAgent, instrumentedClassMethodMap);
        this.mergeLists(instrumentedClassMethodMap, skippedClassMethodMap);
        if (shouldClear) {
            listToFilter.clear();
        }
        return instrumentedClassMethodMap;
    }

    private void mergeLists(HashMap<String, ClassMethodInfo> List1, HashMap<String, ClassMethodInfo> List2) {
        Set<String> keyset = List2.keySet();
        for (String className : keyset) {
            ClassMethodInfo cmvg = List2.get(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo meth = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                ClassMethodInfo filtered = List1.get(className);
                if (filtered == null) {
                    filtered = new ClassMethodInfo(className);
                    List1.put(className, filtered);
                }
                filtered.addMethodWithDirectiveType(meth.methodName, meth.methodDesciptor, meth.directiveType);
            }
        }
    }

    private HashMap readPbdAndCopy() {
        HashMap<String, ClassMethodInfo> pbdList = new HashMap<String, ClassMethodInfo>();
        String fullPath = null;
        try {
            String path = this.getHotdeployInstallationPath();
            if (path != null) {
                fullPath = String.valueOf(path) + "/" + "AutoPersist.pbd";
                File f = new File(fullPath);
                String encoding = System.getProperty("com.wily.introscope.default.encoding");
                if (f.exists()) {
                    FileInputStream in = new FileInputStream(f);
                    BufferedReader bufferedReader = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)in, encoding)) : new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    String methName = null;
                    String methDesc = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        ClassMethodInfo clMethInfo;
                        String[] args = line.split(" ");
                        String directiveType = null;
                        if (args[0].equalsIgnoreCase("TraceOneMethodOfClass:")) {
                            directiveType = "instrument";
                            instrumentedMethodsCountInPbd.getAndIncrement();
                        } else {
                            if (!args[0].equalsIgnoreCase("SkipMethodForClass:")) continue;
                            directiveType = "skip";
                            skippedMethodsCountInPbd.getAndIncrement();
                        }
                        String className = args[1];
                        String methSignature = args[2];
                        int separator = methSignature.indexOf(40);
                        if (separator != -1) {
                            methName = methSignature.substring(0, separator);
                            methDesc = methSignature.substring(separator);
                        }
                        if ((clMethInfo = (ClassMethodInfo)pbdList.get(className)) == null) {
                            clMethInfo = new ClassMethodInfo(className);
                            pbdList.put(className, clMethInfo);
                        }
                        clMethInfo.addMethodWithDirectiveType(methName, methDesc, directiveType);
                    }
                    bufferedReader.close();
                }
            } else if (!this.logInvalidPathMessageFlag) {
                Logger.logMessage((String)"Cannot read the persistence file AutoPersist.pbd since the path to hotdeploy is invalid", (SeverityLevel)SeverityLevel.ERROR);
                this.logInvalidPathMessageFlag = true;
            }
        }
        catch (Exception e) {
            Logger.logException((String)"Error reading from pbd AutoPersist.pbd", (Exception)e);
        }
        return pbdList;
    }

    private boolean isNew(HashMap pbdList, String MethodSignature, boolean isSkipped) {
        Set keyset = pbdList.keySet();
        for (String className : keyset) {
            ClassMethodInfo cmvg = (ClassMethodInfo)pbdList.get(className);
            if (!cmvg.contains(MethodSignature)) continue;
            if (isSkipped) {
                return cmvg.getDirectiveType(MethodSignature).equalsIgnoreCase("skip");
            }
            return false;
        }
        return true;
    }

    private void addMethodToList(String className, MethodInfo mInfo) {
        ClassMethodInfo clMethInfo = this.finalMethodListToWrite.get(className);
        if (clMethInfo == null) {
            clMethInfo = new ClassMethodInfo(className);
            this.finalMethodListToWrite.put(className, clMethInfo);
        }
        clMethInfo.addMethodWithDirectiveType(mInfo.methodName, mInfo.methodDesciptor, mInfo.directiveType);
    }

    private int mergeAllLists(HashMap filteredList, HashMap pbdList) {
        Set keyset = filteredList.keySet();
        Iterator itSkipped = keyset.iterator();
        int traceDirectivesClamp = IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize();
        int blacklistClamp = IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize();
        int newEntriesCount = 0;
        while (itSkipped.hasNext()) {
            String className = (String)itSkipped.next();
            ClassMethodInfo cmvg = (ClassMethodInfo)filteredList.get(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo mInfo = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                if (mInfo.directiveType.equalsIgnoreCase("skip")) {
                    if (this.isNew(pbdList, MethodSignature, false)) {
                        if (skippedMethodsCountInPbd.get() >= blacklistClamp) continue;
                        this.addMethodToList(className, mInfo);
                        skippedMethodsCountInPbd.getAndIncrement();
                        ++newEntriesCount;
                        continue;
                    }
                    if (this.isNew(pbdList, MethodSignature, true) || skippedMethodsCountInPbd.get() >= blacklistClamp) continue;
                    this.addMethodToList(className, mInfo);
                    instrumentedMethodsCountInPbd.getAndDecrement();
                    skippedMethodsCountInPbd.getAndIncrement();
                    ++newEntriesCount;
                    continue;
                }
                if (!mInfo.directiveType.equalsIgnoreCase("instrument") || instrumentedMethodsCountInPbd.get() >= traceDirectivesClamp || !this.isNew(pbdList, MethodSignature, false)) continue;
                this.addMethodToList(className, mInfo);
                instrumentedMethodsCountInPbd.getAndIncrement();
                ++newEntriesCount;
            }
        }
        this.mergeLists(this.finalMethodListToWrite, pbdList);
        return newEntriesCount;
    }

    private void writeToBuffer(StringBuffer fileContentsToWrite, String type) throws Exception {
        Set<String> keyset = this.finalMethodListToWrite.keySet();
        for (String className : keyset) {
            ClassMethodInfo cmvg = this.finalMethodListToWrite.get(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo meth = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                if (type.equalsIgnoreCase("instrument") && type.equalsIgnoreCase(meth.directiveType)) {
                    fileContentsToWrite.append(String.format("TraceOneMethodOfClass: " + className + " " + MethodSignature + " " + "AutoPersistTracer" + " \"" + "Automatic Entry Points|{classname}|{method}" + "\"%n", new Object[0]));
                    continue;
                }
                if (!type.equalsIgnoreCase("skip") || !type.equalsIgnoreCase(meth.directiveType)) continue;
                fileContentsToWrite.append(String.format("SkipMethodForClass: " + className + " " + MethodSignature + "%n", new Object[0]));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void persistToFile() {
        block33: {
            lockAcquired = true;
            bufferedWriter = null;
            fullPath = null;
            try {
                out = null;
                fileName = "AutoPersist.pbd";
                dit = this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
                path = this.getHotdeployInstallationPath();
                encoding = System.getProperty("com.wily.introscope.default.encoding");
                if (path == null) ** GOTO lbl55
                fullPath = String.valueOf(path) + "/" + fileName;
                f = new File(fullPath);
                count = 0;
                retryTimeout = FilePersistenceHelper.retryTimeoutString == null ? 500 : Integer.parseInt(FilePersistenceHelper.retryTimeoutString);
                retryAttempts = FilePersistenceHelper.retryAttemptsString == null ? 3 : Integer.parseInt(FilePersistenceHelper.retryAttemptsString);
                while ((PersistenceFileLockHelper.hasLock() && PersistenceFileLockHelper.isLockValid() || PersistenceFileLockHelper.tryExclusiveLock() == null) && count < retryAttempts) {
                    Thread.sleep(retryTimeout);
                    ++count;
                }
                if (count == retryAttempts) {
                    lockAcquired = false;
                    Logger.logDebugMessage((String)("Skipping the write to " + fullPath + " since the filelock is acquired by another thread/process"));
                    return;
                }
                if (f.exists() && f.lastModified() > dit.getMostRecentLoadTimeStamp()) {
                    Logger.logDebugMessage((String)("Skipping the write to " + fullPath + " because the file has been modified since it was last read"));
                    return;
                }
                try {
                    if (!f.exists()) {
                        out = new FileOutputStream(fullPath, false);
                        bufferedWriter = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding)) : new BufferedWriter(new OutputStreamWriter(out));
                    }
                    if (f.canWrite()) {
                        pbdList = this.readPbdAndCopy();
                        if (out == null || bufferedWriter == null) {
                            out = new FileOutputStream(fullPath, false);
                            bufferedWriter = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding)) : new BufferedWriter(new OutputStreamWriter(out));
                        }
                        newEntriesCount = this.mergeAllLists(this.filteredMethods, pbdList);
                        fileContentsToWrite = new StringBuffer();
                        fileContentsToWrite.append(IntelligentInstrumentationExtensionConstants.FILE_HEADER_STRING);
                        fileContentsToWrite.append(IntelligentInstrumentationExtensionConstants.SET_TRACER_CLASS_MAPPING);
                        this.writeToBuffer(fileContentsToWrite, "instrument");
                        this.writeToBuffer(fileContentsToWrite, "skip");
                        bufferedWriter.write(fileContentsToWrite.toString());
                        this.finalMethodListToWrite.clear();
                        this.filteredMethods.clear();
                        bufferedWriter.close();
                        if (newEntriesCount > 0) {
                            Logger.logInfoMessage((String)(String.valueOf(newEntriesCount) + " new entries were persisted in " + fullPath));
                        }
                    } else if (!this.logPermissionMessageFlag) {
                        Logger.logMessage((String)("Cannot write to the persistence file " + fullPath + ". Please enable write permissions"), (SeverityLevel)SeverityLevel.ERROR);
                        this.logPermissionMessageFlag = true;
                    }
                    break block33;
lbl55:
                    // 1 sources

                    if (!this.logInvalidPathMessageFlag) {
                        Logger.logMessage((String)"Cannot write to the persistence file AutoPersist.pbd since the path to hotdeploy is invalid", (SeverityLevel)SeverityLevel.ERROR);
                        this.logInvalidPathMessageFlag = true;
                    }
                }
                catch (FileNotFoundException v0) {
                    Logger.logMessage((String)("Error writing to pbd " + fullPath + ". Please enable write permissions."), (SeverityLevel)SeverityLevel.ERROR);
                }
                catch (Exception e) {
                    Logger.logMessage((String)("Error writing to pbd " + fullPath + " " + e.getMessage()), (SeverityLevel)SeverityLevel.ERROR);
                }
            }
            finally {
                try {
                    if (lockAcquired) {
                        PersistenceFileLockHelper.releaseLock();
                        lockAcquired = false;
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    Logger.logException((String)"Error releasing lock after writing to AutoPersist.pbd", (Exception)e);
                }
            }
        }
    }

    private void setLogBitMask(int mask) {
        this.logBitMask |= mask;
    }

    private void clearLogBitMask(int mask) {
        this.logBitMask &= ~mask;
    }

    public static int getInstrumentedMethodsCountInPbd() {
        return instrumentedMethodsCountInPbd.get();
    }

    public static int getSkippedMethodsCountInPbd() {
        return skippedMethodsCountInPbd.get();
    }

    private String getHotdeployInstallationPath() {
        String[] directivesList = AutoProbeTransformer.getDirectivesFileList();
        int i = 0;
        while (i < directivesList.length) {
            if (directivesList[i].endsWith("hotdeploy")) {
                return directivesList[i];
            }
            ++i;
        }
        return null;
    }

    public void notifyDirectivesLoaded() {
        this.pbdStateChanged = true;
    }

    public void notifyRedefinitionComplete() {
    }
}

