/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.wstracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;

public class SysviewWSTracer
extends ASingleInstanceTracerFactory
implements ITracer {
    private static final String kLaunchSessionSysviewWebServiceName = "LaunchSessionSysviewWebServiceName";
    private static final String kWebServiceName = "Web Service Name";
    private static final String kLaunchSessionWithAgentsKey = "LaunchSessionWithAgents";
    private static final String kLaunchSessionWithAgentsValue = "(SYSVIEW.*|Cross-Enterprise.*)";
    private static final String kNamespaceKey = "com.wily.powerpack.webservices.trace.NamespaceKey";
    private static final String kLaunchSessionSysviewTime = "LaunchSessionSysviewTime";

    public SysviewWSTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long clockElapsedTimeInMicros = data.getWallClockElapsedTime() * 1000L;
        long estimatedDurationThreshold = (clockElapsedTimeInMicros - 500L) / 2L;
        if (clockElapsedTimeInMicros == 0L) {
            estimatedDurationThreshold = 0L;
        }
        this.SetExtraParameter(kLaunchSessionSysviewTime, String.valueOf(estimatedDurationThreshold));
        String nameSpaceKey = (String)data.get(kNamespaceKey);
        if (nameSpaceKey == null) {
            return;
        }
        int index = nameSpaceKey.lastIndexOf("/", nameSpaceKey.length());
        String wsName = nameSpaceKey.substring(index + 1, nameSpaceKey.length());
        if (wsName != null && wsName.length() > 0) {
            this.SetExtraParameter(kLaunchSessionSysviewWebServiceName, wsName);
            this.SetExtraParameter(kWebServiceName, wsName);
            this.SetExtraParameter(kLaunchSessionWithAgentsKey, kLaunchSessionWithAgentsValue);
        }
    }

    private void SetExtraParameter(String key, String value) {
        this.getComponentTracer().addExtraParameter(key, value);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

