/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.powerpack.websphereMQ.agent.extensions.MQConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.MQProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class TraceProperties
implements TraceConstants {
    private static IModuleFeedbackChannel logger = null;
    private static Module kModule = new Module("MQProperties");
    private MQProperties mqProps = null;
    private static TraceProperties tp = null;
    public static String HANDSHAKE_MQAGENT_ID_VALUE = null;
    public static String HANDSHAKE_QM_HOST_VALUE = null;
    public static String HANDSHAKE_QM_CHANNEL_VALUE = null;
    public static Integer HANDSHAKE_QM_PORT_VALUE = null;
    public static String HANDSHAKE_QUEUE_NAME_VALUE = null;
    public static Integer HANDSHAKE_QM_CHARACTER_SET_VALUE = null;
    public static String HANDSHAKE_QM_SSL_VALUE = null;
    public static String HANDSHAKE_QM_CHANNEL_CIPHERSPEC_VALUE = "Not Applicable";
    public static String HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE = "";
    public static String handshake_qm_channel_cipherspec_prop_value = "";
    public static String HANDSHAKE_MQAGENT_ID_MORPHED_VALUE = null;
    public static boolean isValidMQAgentId = false;
    private static String HANDSHAKE_EXTRACT_USERID_VALUE = null;
    public static boolean extractUserid = false;
    public static Map excludeQMQueuesRegexMap = new HashMap();
    public static boolean MQNAMEFORMATTER_QM_CONNECTION = true;
    private static boolean MQ_CPT_FLAG = false;
    private static boolean MQ_SYSVIEW_FLAG = true;
    private static boolean handshakePropertiesLoaded = false;
    public static String MQ_DISCOVERY_QUEUE_NAME_VALUE = null;
    public static String MQ_DISCOVERY_ENABLE = null;
    private static boolean MQ_DISCOVERY_FLAG = false;
    private static boolean MQHEADER_INSERTION_FLAG = true;
    private static boolean MQHEADER_READ_FLAG = true;

    static {
        logger = MQPPLog.getLogger();
        TraceProperties.getInstance();
    }

    public static synchronized TraceProperties getInstance() {
        if (tp == null) {
            tp = new TraceProperties();
            TraceProperties.tp.mqProps = MQProperties.instance(logger);
            if (TraceProperties.tp.mqProps != null) {
                if (tp.initialiseValues()) {
                    logger.info(kModule, tp.toString());
                }
            } else {
                logger.error(kModule, "MQProperties is not loaded successfully");
            }
        }
        return tp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MQProperties is loaded and configured for Transaction trace functionality");
        sb.append("\n\tmq.crossprocesstracing.enabled: " + MQ_CPT_FLAG);
        sb.append("\n\tmq.sysviewtracing.enabled: " + MQ_SYSVIEW_FLAG);
        sb.append("\n\tmqtracing.exclude.queues.regex: " + excludeQMQueuesRegexMap);
        if (handshakePropertiesLoaded) {
            sb.append("\n\tmqmonitor.mqagent.id.list: " + HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE);
            sb.append("\n\thandshake.mqagent.id: " + HANDSHAKE_MQAGENT_ID_VALUE);
            sb.append("\n\thandshake.qm.host: " + HANDSHAKE_QM_HOST_VALUE);
            sb.append("\n\thandshake.qm.channelname: " + HANDSHAKE_QM_CHANNEL_VALUE);
            sb.append("\n\thandshake.qm.port: " + HANDSHAKE_QM_PORT_VALUE);
            sb.append("\n\thandshake.queue: " + HANDSHAKE_QUEUE_NAME_VALUE);
            sb.append("\n\thandshake.qm.character.set: " + HANDSHAKE_QM_CHARACTER_SET_VALUE);
            sb.append("\n\thandshake.qm.ssl: " + HANDSHAKE_QM_SSL_VALUE);
            sb.append("\n\thandshake.qm.channel.ssl.cipherspec: " + handshake_qm_channel_cipherspec_prop_value);
        }
        sb.append("\n\tmq.autodiscovery.enabled: " + MQ_DISCOVERY_FLAG);
        if (MQ_DISCOVERY_FLAG) {
            sb.append("\n\tmq.autodiscovery.queue: " + MQ_DISCOVERY_QUEUE_NAME_VALUE);
        }
        sb.append("\n\tcom.wily.introscope.agent.mqheaderinsertion.enabled: " + MQHEADER_INSERTION_FLAG);
        sb.append("\n\tcom.wily.introscope.agent.mqheaderread.enabled: " + MQHEADER_READ_FLAG);
        return sb.toString();
    }

    private void loadMQClientAgentNamesValues() {
        HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE = this.mqProps.getProperty("mqmonitor.mqagent.id.list");
        if (HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE == null || HANDSHAKE_MQCLIENT_AGENT_NAMES_VALUE.length() == 0) {
            logger.warn(kModule, "mqmonitor.mqagent.id.list value is null. Recommended: MQMonitor agent name(s) should be provided if any configured. ");
        }
    }

    private void loadHiddenProperties() {
        try {
            HANDSHAKE_EXTRACT_USERID_VALUE = this.mqProps.getProperty("handshake.extract.userid");
            extractUserid = VALUE_HANDSHAKE_EXTRACT_USERID_ENABLE.equalsIgnoreCase(HANDSHAKE_EXTRACT_USERID_VALUE);
        }
        catch (Exception exception) {
            extractUserid = false;
        }
    }

    private void loadHotDeployProperties() {
        String mqSysviewFlag = this.mqProps.getProperty("mq.sysviewtracing.enabled", FALSE);
        if (FALSE.equalsIgnoreCase(mqSysviewFlag)) {
            MQ_SYSVIEW_FLAG = false;
            logger.info(kModule, "MQ SYSVIEW cross process tracing flag has been set to " + MQ_SYSVIEW_FLAG);
        } else {
            MQ_SYSVIEW_FLAG = true;
            logger.info(kModule, "MQ SYSVIEW cross process tracing flag has been set to " + MQ_SYSVIEW_FLAG);
        }
    }

    private void loadMQExcludeQueuesList(boolean initialize) {
        Enumeration<?> propNames = this.mqProps.propertyNames();
        String propertyName = null;
        String qmName = null;
        String queueRegex = null;
        Pattern queuePattern = null;
        while (propNames.hasMoreElements()) {
            propertyName = propNames.nextElement().toString();
            if (!propertyName.endsWith("mqtracing.exclude.queues.regex") || propertyName.indexOf("mqtracing.exclude.queues.regex") <= 0) continue;
            qmName = propertyName.substring(0, propertyName.indexOf("mqtracing.exclude.queues.regex") - 1);
            queueRegex = this.mqProps.getProperty(propertyName);
            if (qmName == null || qmName.trim().length() == 0 || queueRegex == null || queueRegex.trim().length() == 0) continue;
            queuePattern = Pattern.compile(queueRegex);
            excludeQMQueuesRegexMap.put(qmName, queuePattern);
        }
        if (initialize) {
            logger.info(kModule, "Loaded queue manager(s) exclude queue(s) regex property (<queue manager name>|<queue name regex>) mqtracing.exclude.queues.regex: " + excludeQMQueuesRegexMap);
        } else {
            logger.info(kModule, "Reloaded queue manager(s) exclude queue(s) regex property (<queue manager name>|<queue name regex>) mqtracing.exclude.queues.regex: " + excludeQMQueuesRegexMap);
        }
    }

    private void loadQMConnectionProperty() {
        MQNAMEFORMATTER_QM_CONNECTION = Boolean.parseBoolean(this.mqProps.getProperty("mq.nameformatter.qm.connection.create.enable", TraceConstants.MQNAMEFORMATTER_QM_CONNECTION_DEFAULT));
    }

    private void loadDiscoveryProperties() {
        MQ_DISCOVERY_ENABLE = this.mqProps.getProperty("mq.autodiscovery.enabled");
        if (FALSE.equalsIgnoreCase(MQ_DISCOVERY_ENABLE)) {
            MQ_DISCOVERY_FLAG = false;
            logger.info(kModule, "MQ auto discovery enable flag has been set to " + MQ_DISCOVERY_FLAG);
        } else {
            MQ_DISCOVERY_FLAG = true;
            logger.info(kModule, "MQ auto discovery enable flag has been set to " + MQ_DISCOVERY_FLAG);
        }
        if (MQ_DISCOVERY_FLAG && ((MQ_DISCOVERY_QUEUE_NAME_VALUE = this.mqProps.getProperty("mq.autodiscovery.queue")) == null || MQ_DISCOVERY_QUEUE_NAME_VALUE.length() == 0)) {
            MQ_DISCOVERY_QUEUE_NAME_VALUE = "CA_WILY_AUTODISCOVERY";
            logger.warn("MQTrace: mq.autodiscovery.queue value is not provided. Taking the default autodiscovery queue name: CA_WILY_AUTODISCOVERY");
        }
        if (!MQ_CPT_FLAG) {
            this.loadCommonDiscoveryHandshakeProperties();
        }
    }

    private void loadCommonDiscoveryHandshakeProperties() {
        try {
            int handshakeAgentId = Integer.parseInt(System.getProperty("handshake.mqagent.id", "-1").trim());
            if (handshakeAgentId <= 0) {
                handshakeAgentId = Integer.parseInt(this.mqProps.getProperty("handshake.mqagent.id", "").trim());
            }
            if (handshakeAgentId > 999999999 || handshakeAgentId < 1) {
                logger.warn("handshake.mqagent.id = " + handshakeAgentId + " is not in range of [" + 1 + " - " + 999999999 + "]. Handshake will not be started without valid value.");
            } else {
                isValidMQAgentId = true;
                HANDSHAKE_MQAGENT_ID_VALUE = String.valueOf(handshakeAgentId);
                HANDSHAKE_MQAGENT_ID_MORPHED_VALUE = "MQClient-" + HANDSHAKE_MQAGENT_ID_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("handshake.mqagent.id value is blank or not a number. This is mandatory property for MQ trace. Handshake will not be started without valid value.");
        }
        HANDSHAKE_QM_HOST_VALUE = this.mqProps.getProperty("handshake.qm.host", "localhost").trim();
        if (HANDSHAKE_QM_HOST_VALUE.length() == 0) {
            logger.info("handshake.qm.host value is null or blank. System will pick up default value: localhost");
            HANDSHAKE_QM_HOST_VALUE = "localhost";
        }
        if ((HANDSHAKE_QM_CHANNEL_VALUE = this.mqProps.getProperty("handshake.qm.channelname", "SYSTEM.AUTO.SVRCONN").trim()).length() == 0) {
            logger.info("handshake.qm.channelname value is null or blank. System will pick up default value: SYSTEM.AUTO.SVRCONN");
            HANDSHAKE_QM_CHANNEL_VALUE = "SYSTEM.AUTO.SVRCONN";
        }
        if ((HANDSHAKE_QUEUE_NAME_VALUE = this.mqProps.getProperty("handshake.queue", "CA_WILY_HANDSHAKE").trim()).length() == 0) {
            logger.info("handshake.queue value is null or blank. System will pick up default value: CA_WILY_HANDSHAKE");
            HANDSHAKE_QUEUE_NAME_VALUE = "CA_WILY_HANDSHAKE";
        }
        try {
            HANDSHAKE_QM_PORT_VALUE = Integer.valueOf(this.mqProps.getProperty("handshake.qm.port", String.valueOf(HANDSHAKE_QM_PORT_DEFAULT)).trim());
        }
        catch (NumberFormatException numberFormatException) {
            logger.info("handshake.qm.port value is not a number. System will pick up default value: " + HANDSHAKE_QM_PORT_DEFAULT);
            HANDSHAKE_QM_PORT_VALUE = HANDSHAKE_QM_PORT_DEFAULT;
        }
        try {
            HANDSHAKE_QM_CHARACTER_SET_VALUE = Integer.valueOf(this.mqProps.getProperty("handshake.qm.character.set", String.valueOf(HANDSHAKE_QM_CHARACTER_SET_DEFAULT)).trim());
        }
        catch (NumberFormatException numberFormatException) {
            logger.info("handshake.qm.character.set value is not a number. System will pick up default value: " + HANDSHAKE_QM_CHARACTER_SET_DEFAULT);
            HANDSHAKE_QM_CHARACTER_SET_VALUE = HANDSHAKE_QM_CHARACTER_SET_DEFAULT;
        }
        HANDSHAKE_QM_SSL_VALUE = this.mqProps.getProperty("handshake.qm.ssl", HANDSHAKE_QM_SSL_DEFAULT).trim();
        if (HANDSHAKE_QM_SSL_VALUE.length() == 0) {
            logger.info("handshake.qm.ssl value is null or blank. System will pick up default value: CA_WILY_HANDSHAKE");
            HANDSHAKE_QM_SSL_VALUE = HANDSHAKE_QM_SSL_DEFAULT;
        }
        if (TraceConstants.ENABLE.equals(HANDSHAKE_QM_SSL_VALUE)) {
            handshake_qm_channel_cipherspec_prop_value = this.mqProps.getProperty("handshake.qm.channel.ssl.cipherspec", "").trim();
            if (handshake_qm_channel_cipherspec_prop_value.length() == 0) {
                logger.warn("SSL is enabled for handshake queue manager but, cipherspec handshake.qm.channel.ssl.cipherspec value is null or blank.");
            } else if (MQConstants.cipherMap.get(handshake_qm_channel_cipherspec_prop_value) != null) {
                HANDSHAKE_QM_CHANNEL_CIPHERSPEC_VALUE = (String)MQConstants.cipherMap.get(handshake_qm_channel_cipherspec_prop_value);
            } else {
                logger.warn("SSL is enabled for handshake queue manager but, cipherspec handshake.qm.channel.ssl.cipherspec = " + handshake_qm_channel_cipherspec_prop_value + " value is not a valid one.");
            }
        }
    }

    private void loadOneTimeProperties() {
        String mqCPTFlag = this.mqProps.getProperty("mq.crossprocesstracing.enabled", FALSE);
        if (TRUE.equalsIgnoreCase(mqCPTFlag)) {
            MQ_CPT_FLAG = true;
            logger.info(kModule, "MQ cross process tracing flag has been set to " + MQ_CPT_FLAG);
        } else {
            MQ_CPT_FLAG = false;
            logger.info(kModule, "MQ cross process tracing flag has been set to " + MQ_CPT_FLAG);
        }
        if (MQ_CPT_FLAG) {
            this.loadCommonDiscoveryHandshakeProperties();
            handshakePropertiesLoaded = true;
        }
    }

    private boolean initialiseValues() {
        try {
            MQHEADER_INSERTION_FLAG = AgentShim.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.mqheaderinsertion.enabled", true);
            MQHEADER_READ_FLAG = AgentShim.getAgent().IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.mqheaderread.enabled", true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        this.loadHotDeployProperties();
        this.loadMQExcludeQueuesList(true);
        this.loadOneTimeProperties();
        if (MQ_CPT_FLAG) {
            this.loadMQClientAgentNamesValues();
        }
        this.loadDiscoveryProperties();
        this.loadQMConnectionProperty();
        return true;
    }

    public synchronized void reload() {
        this.mqProps.reload();
        this.loadHotDeployProperties();
        this.loadMQExcludeQueuesList(false);
        if (MQ_CPT_FLAG) {
            this.loadMQClientAgentNamesValues();
            this.loadHiddenProperties();
        }
    }

    public static boolean shouldTraceMQCPT() {
        return MQ_CPT_FLAG;
    }

    public static boolean shouldTraceMQSYSVIEW() {
        return MQ_SYSVIEW_FLAG;
    }

    public static boolean shouldStartDiscovery() {
        return MQ_DISCOVERY_FLAG;
    }

    public static boolean shouldInsertIntoMQHeader() {
        return MQHEADER_INSERTION_FLAG;
    }

    public static boolean shouldReadFromMQHeader() {
        return MQHEADER_READ_FLAG;
    }
}

