/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.SOAPUtils;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.fault.ASOAPFaultTracer;
import com.wily.util.properties.AttributeListing;

public class WAS6ServerFaultTracer
extends ASOAPFaultTracer {
    public WAS6ServerFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected Object getMessageContext(InvocationData data) {
        Object context = data.getInvocationParameterAsObject(3);
        return context;
    }

    protected boolean reportFaultIfExists(InvocationData data) {
        boolean faultExists = false;
        try {
            Object fault;
            Object body = SOAPUtils.getBody(this.getMessageContext(data));
            Boolean hasFault = (Boolean)WSMUtils.invokeMethodOnObject(body, "hasFault");
            if (hasFault.booleanValue() && (fault = WSMUtils.invokeMethodOnObject(body, "getFault")) != null) {
                String faultString = (String)WSMUtils.invokeMethodOnObject(fault, "getFaultString");
                this.reportFault(faultString, data);
                faultExists = true;
            }
            if (!faultExists && data.hasInvocationThrownException()) {
                this.reportFault(data.getInvocationThrownException().getMessage(), data);
                faultExists = true;
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Fault", bomb);
        }
        return faultExists;
    }
}

