/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class JAXWSNameFormatter
implements INameFormatter,
KConstants {
    protected final IAgent fAgent;
    protected String operationName = "UnknownOperationName";
    protected String serviceName = "UnknownService";
    protected String namespace = "UnknownNamespace";
    protected IModuleFeedbackChannel logger;

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public JAXWSNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    protected String getOperationName(InvocationData data) {
        return this.operationName;
    }

    protected String getServiceName(InvocationData data) {
        return this.serviceName;
    }

    protected String getNamespace(InvocationData data) {
        return this.namespace;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name != null) {
            if (name.indexOf("{namespace}", 0) >= 0) {
                this.namespace = this.getNamespace(data);
                if (this.namespace == null) {
                    this.namespace = this.getServiceName(data);
                }
                this.namespace = WSMUtils.formatToBeResourceSafe(this.namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)this.namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                this.serviceName = this.getServiceName(data);
                if (this.serviceName == null) {
                    this.serviceName = "UnknownService";
                }
                this.serviceName = WSMUtils.formatToBeResourceSafe(this.serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)this.serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                this.operationName = this.getOperationName(data);
                if (this.operationName == null) {
                    this.operationName = "UnknownOperationName";
                }
                this.operationName = WSMUtils.formatToBeResourceSafe(this.operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)this.operationName);
            }
        }
        return name;
    }
}

