/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;

public class JaxRpcCallFormatter
extends ANameFormatter {
    public JaxRpcCallFormatter(IAgent agent) {
        super(agent);
    }

    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        Object call = null;
        try {
            call = data.getInvocationObject();
            try {
                Object operation = WSMUtils.invokeMethodOnObject(call, "getOperationName");
                if (operation != null) {
                    namespaceURI = (String)WSMUtils.invokeMethodOnObject(operation, "getNamespaceURI");
                }
                if (namespaceURI == null || namespaceURI.trim().length() == 0) {
                    namespaceURI = (String)WSMUtils.invokeMethodOnObject(call, "getTargetEndpointAddress");
                }
                namespaceURI = WSMUtils.formatURLToBeResourceSafe(namespaceURI);
            }
            catch (NullPointerException nullPointerException) {
                namespaceURI = null;
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + call.getClass() + " " + bomb;
            WSMUtils.handleError(this.getAgent(), message, bomb);
        }
        return namespaceURI == null || namespaceURI.equals("") ? "UnknownService" : namespaceURI;
    }

    public String getServiceName(InvocationData data) {
        String serviceName = null;
        Object call = null;
        try {
            call = data.getInvocationObject();
            serviceName = (String)WSMUtils.invokeMethodOnObject(call, "getTargetEndpointAddress");
            serviceName = WSMUtils.formatURLToBeResourceSafe(serviceName);
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + " Caught unexpected exception while resolving ServiceName " + call.getClass() + " " + bomb;
            WSMUtils.handleError(this.getAgent(), message, bomb);
        }
        return serviceName == null || serviceName.equals("") ? "UnknownService" : serviceName;
    }

    public final String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            Object operation;
            Object invocationObject;
            if (data != null && (invocationObject = data.getInvocationObject()) != null && (operation = WSMUtils.invokeMethodOnObject(invocationObject, "getOperationName")) != null) {
                operationName = (String)WSMUtils.invokeMethodOnObject(operation, "getLocalPart");
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", bomb);
        }
        return operationName == null || operationName.equals("") ? "UnknownOperationName" : operationName;
    }
}

