/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ClientNameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;

    public Axis2ClientNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ClientNameFormatter:: getServiceName");
        }
        Object call = null;
        try {
            call = data.getInvocationObject();
            if (call != null && (call = WSMUtils.invokeMethodOnObject(call, "getOptions")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getTo")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(call, "getAddress");
                serviceURI = WSMUtils.removeTrailingSlash(serviceURI);
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ClientNameFormatter getServiceName ", bomb);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ClientNameFormatter:: getServiceName serviceURI=" + serviceURI);
        }
        return serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object operationClient = data.getInvocationObject();
        Object messageContext = WSMUtils.invokeMethodOnObject(operationClient, "getMessageContext", new Class[]{String.class}, new Object[]{"Out"});
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            Object child = this.getChild(data);
            Object qName = WSMUtils.invokeMethodOnObject(child, "getQName");
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter:: namespaceURI= " + namespaceURI);
            }
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + "Axis2ClientNameFormatter getNamespace " + data.getInvocationObject().getClass();
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Axis2ClientNameFormatter getNamespace2", bomb);
            }
        }
        return namespaceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            operationName = (String)WSMUtils.invokeMethodOnObject(this.getChild(data), "getLocalName");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter:: getOperationName operationName= " + operationName);
            }
        }
        catch (Throwable bomb) {
            try {
                String message = "Axis2ClientNameFormatter getOperationName " + data.getInvocationObject().getClass();
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Axis2ClientNameFormatter getOperationName 2", bomb);
            }
        }
        return operationName;
    }
}

