/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ClientOutIn2NameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;

    public Axis2ClientOutIn2NameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        try {
            Object messageContext = data.getInvocationParameterAsObject(1);
            Object endpointReference = WSMUtils.invokeMethodOnObject(messageContext, "getTo");
            serviceURI = (String)WSMUtils.invokeMethodOnObject(endpointReference, "getAddress");
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ClientOutIn2NameFormatter getServiceName " + bomb, bomb);
        }
        return serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object messageContext = data.getInvocationParameterAsObject(1);
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    public String getNamespace(InvocationData data) {
        String namespaceURI = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        if (namespaceURI != null) {
            return namespaceURI;
        }
        try {
            Object child = this.getChild(data);
            Object qName = WSMUtils.invokeMethodOnObject(child, "getQName");
            this.logger.debug("Axis2ClientOutIn2NameFormatter:: QName= " + qName);
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            this.logger.debug("Axis2ClientOutIn2NameFormatter:: namespaceURI= " + namespaceURI);
        }
        catch (Throwable bomb) {
            try {
                String message = " Axis2ClientOutIn2NameFormatter getNamespace " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Axis2ClientOutIn2NameFormatter getNamespace 2 ", bomb);
            }
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            namespaceURI = "UnknownService";
        }
        data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespaceURI);
        return namespaceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            operationName = (String)WSMUtils.invokeMethodOnObject(this.getChild(data), "getLocalName");
            this.logger.debug("Axis2ClientOutIn2NameFormatter:: getOperationName operationName= " + operationName);
        }
        catch (Throwable bomb) {
            try {
                String message = "Axis2ClientOutIn2NameFormatter getOperationName " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Axis2ClientOutIn2NameFormatter getOperationName 2 ", bomb);
            }
        }
        return operationName;
    }
}

