/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.consumer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.ANameFormatter;
import com.wily.powerpack.webservices.WSMUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WASFormatter
extends ANameFormatter {
    public WASFormatter(IAgent agent) {
        super(agent);
    }

    public String getOperation(InvocationData data) {
        Object o = data.getInvocationParameterAsObject(0);
        String name = null;
        try {
            Object operation = WSMUtils.invokeMethodOnObject(o, "getOperation");
            name = (String)WSMUtils.invokeMethodOnObject(operation, "getName");
            if (name == null) {
                name = this.getNameFromQName(operation);
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
        }
        return name == null ? "UnknownOperationName" : name;
    }

    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object wlcontext = data.getInvocationParameterAsObject(0);
            Class<?> cl = wlcontext.getClass();
            Method m = WSMUtils.findGetPropertyWithStringArgMethod(cl);
            Object value = m.invoke(wlcontext, (Object[])new String[]{"javax.xml.rpc.service.endpoint.address"});
            name = WSMUtils.toString(value);
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null ? "UnknownService" : name;
    }

    private String getNameFromQName(Object operation) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object elementQName = WSMUtils.invokeMethodOnObject(operation, "getElementQName");
        Object localPart = WSMUtils.invokeMethodOnObject(elementQName, "getLocalPart");
        return WSMUtils.toString(localPart);
    }
}

