/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.SOAPUtils;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.trace.AFaultTracer;
import com.wily.util.properties.AttributeListing;

public abstract class AProducerFaultTracer
extends AFaultTracer {
    public AProducerFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected boolean reportFaultIfExists(InvocationData data) {
        boolean faultExists = false;
        try {
            Object fault;
            Object context = this.getMessageContext(data);
            Object body = SOAPUtils.getBody(SOAPUtils.getMessage(context));
            Boolean hasFault = (Boolean)WSMUtils.invokeMethodOnObject(body, "hasFault");
            if (hasFault.booleanValue() && (fault = WSMUtils.invokeMethodOnObject(body, "getFault")) != null) {
                String faultString = (String)WSMUtils.invokeMethodOnObject(fault, "getFaultString");
                this.reportFault(faultString, data);
                faultExists = true;
            }
            if (!faultExists && data.hasInvocationThrownException()) {
                this.reportFault(data.getInvocationThrownException().getMessage(), data);
                faultExists = true;
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Fault", t);
        }
        return faultExists;
    }

    protected abstract Object getMessageContext(InvocationData var1);
}

