/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.operations;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractRegexOperation {
    protected static ThreadLocal sPatterns = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    protected static Matcher getMatcher(String patternValue, String inputValue) {
        Pattern p = AbstractRegexOperation.getPattern(patternValue);
        return p.matcher(inputValue);
    }

    protected static Pattern getPattern(String patternValue) {
        HashMap map = (HashMap)sPatterns.get();
        Pattern pattern = (Pattern)map.get(patternValue);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(patternValue);
        map.put(patternValue, pattern);
        return pattern;
    }

    protected static String escapeUnsupportedRegexChars(String clearText) {
        StringBuffer result = new StringBuffer();
        int x = 0;
        while (x < clearText.length()) {
            char currentChar = clearText.charAt(x);
            if (AbstractRegexOperation.requiresUnsupportedEscape(currentChar)) {
                result.append("\\");
            }
            result.append(currentChar);
            ++x;
        }
        return result.toString();
    }

    protected static boolean requiresUnsupportedEscape(char inputCharacter) {
        switch (inputCharacter) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    protected static String replace(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuffer sb = new StringBuffer();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }

    protected static boolean paramValueExceedSize(String value) {
        return value != null && value.length() > 10000;
    }
}

