/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.IConfigurationListener;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;

public class ConfigurationWatcher
implements ITimestampedRunnable {
    private File fConfigurationFile;
    private long fLastModified;
    private IntervalHeartbeat heartbeat;
    private IResource resource;
    private IRegisteredBehavior behavior;
    private WeakHashSet listeners;
    private IModuleFeedbackChannel feedback;
    private int consecutiveFailures;
    private volatile IndexedProperties props;
    private static final int kConsecutiveFailureThreshold = 10;

    public ConfigurationWatcher(IntervalHeartbeat heartbeat, IResource resource, IModuleFeedbackChannel feedback) {
        if (resource.IResource_isFileResource()) {
            this.heartbeat = heartbeat;
            this.resource = resource;
            this.feedback = feedback;
            this.props = this.reloadConfiguration();
            this.consecutiveFailures = 0;
            FileBasedResource fileResource = (FileBasedResource)resource;
            this.fConfigurationFile = new File(fileResource.IResource_getLocation());
            this.fLastModified = this.fConfigurationFile.lastModified();
            this.listeners = new WeakHashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (this.contentsChanged()) {
            HashSet iterateOn = null;
            WeakHashSet weakHashSet = this.listeners;
            synchronized (weakHashSet) {
                if (this.listeners.size() > 0) {
                    iterateOn = new HashSet(this.listeners.keySet());
                }
            }
            if (iterateOn != null) {
                IndexedProperties newProps;
                this.props = newProps = this.reloadConfiguration();
                if (newProps != null) {
                    Iterator it = iterateOn.iterator();
                    while (it.hasNext()) {
                        IConfigurationListener listener = (IConfigurationListener)it.next();
                        listener.onChange(newProps);
                    }
                }
            }
        }
    }

    private IndexedProperties reloadConfiguration() {
        IndexedProperties result;
        block6: {
            result = null;
            try {
                if (this.consecutiveFailures < 10) {
                    IndexedProperties newProps = new IndexedProperties();
                    if (this.resource instanceof FileBasedResource) {
                        newProps.load(this.resource.IResource_getSourceContents());
                    } else {
                        newProps.load(this.resource.IResource_getContents());
                    }
                    this.consecutiveFailures = 0;
                    result = newProps;
                }
            }
            catch (Exception e) {
                if (this.feedback != null) {
                    this.feedback.warn("Error re-loading configuration resource " + this.resource.IResource_getLocation());
                    this.feedback.verbose(e);
                }
                ++this.consecutiveFailures;
                if (this.consecutiveFailures != 10 || this.feedback == null) break block6;
                this.feedback.warn("10 consecutive failures attempting to re-load properties, giving up");
                this.heartbeat.removeBehavior(this.behavior);
            }
        }
        return result;
    }

    public void shutdown() {
        if (this.behavior != null) {
            this.heartbeat.removeBehavior(this.behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationListener(IConfigurationListener listener) {
        boolean startBehavior = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.listeners.size() == 0) {
                startBehavior = true;
            }
            this.listeners.add(listener);
        }
        listener.onChange(this.props);
        if (startBehavior) {
            this.behavior = this.heartbeat.addBehavior((ITimestampedRunnable)this, "Dynamic Logging", true, 60000L, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigurationListener(IConfigurationListener listener) {
        boolean stopBehavior = false;
        boolean result = false;
        ConfigurationWatcher configurationWatcher = this;
        synchronized (configurationWatcher) {
            if (this.listeners.size() > 0) {
                result = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    stopBehavior = true;
                }
            }
        }
        if (stopBehavior) {
            this.shutdown();
        }
        return result;
    }

    private boolean contentsChanged() {
        long currentLastModified;
        if (this.fConfigurationFile.exists() && (currentLastModified = this.fConfigurationFile.lastModified()) > this.fLastModified) {
            this.fLastModified = currentLastModified;
            return true;
        }
        return false;
    }

    public IndexedProperties getProperties() {
        return this.props;
    }
}

