/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteResultByNamedProxyTransformationBuilder;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;

public final class SubstituteResultByNamedProxyIfFlaggedDirective
extends ADirective {
    private static final String kMethodMustHaveExactlyOneParameterMessage = "Method must have exactly one parameter: ";
    private static final String kParameterMustBeObjectReferenceMessage = "Method must have an object reference type for the parameter: ";
    private static final String kParameterAndReturnTypeMustMatchMessage = "Method must have matching parameter and return types: ";
    private static final String kReturnTypeMustNotBeVoid = "Return type must not be void";
    private final FlagName fFlagName;
    private final IMethodName fSourceMethod;
    private final String fSubstituter;

    public SubstituteResultByNamedProxyIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IMethodName sourceMethod, String substituterName) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(sourceMethod, substituterName);
        this.fFlagName = flagName;
        this.fSourceMethod = sourceMethod;
        this.fSubstituter = substituterName;
    }

    private void validateParameters(IMethodName sourceMethod, String substituterName) throws InvalidDirectiveException {
        IMethodSignature sourceDescriptor = sourceMethod.getSignature();
        ISlotSignature sourceReturnType = sourceDescriptor.getReturnSlotSignature();
        if (sourceReturnType.isVoid()) {
            throw new InvalidDirectiveException(kReturnTypeMustNotBeVoid, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Result_Return_Types_Must_Match"));
        }
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    private String getSubstituterName() {
        return this.fSubstituter;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubstituteResultByNamedProxyTransformationBuilder(tracerGroupBuilder, this.getSourceMethod(), this.getSubstituterName()));
    }
}

