/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.diagnos.personality.java.compiler.DGStreamBatchCompiler;
import com.wily.diagnos.personality.java.compiler.DGZipCompiler;
import com.wily.util.io.DeletionFailedException;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.LazyFileOutputStream;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public class DGFolderCompiler
extends DGStreamBatchCompiler {
    private static final String kEmptyDirectory = "Directory contains no files";
    private static final String kCopyFailedMessage = "An error occurred while attempting to copy the file";
    private File fRootFolder;
    private File fDestFolder;
    private LiveTraversal fTraversal;

    public DGFolderCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, File rootFolder, File destFolder) throws IOException {
        this(settings, fileSettings, ui, log, rootFolder, destFolder, true);
    }

    public DGFolderCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, File rootFolder, File destFolder, boolean includeSubFolders) throws IOException {
        super(settings, fileSettings, ui, log);
        if (rootFolder == null) {
            throw new NullPointerException("no source folder specified");
        }
        this.fRootFolder = rootFolder;
        if (destFolder == null) {
            throw new NullPointerException("no target folder specified");
        }
        this.fDestFolder = destFolder;
        this.fTraversal = new LiveTraversal(fileSettings, this.fRootFolder, this.fDestFolder, includeSubFolders);
    }

    public void compileAll() throws DGCompilationFailedException {
        this.prepareDestinationFolder(this.fDestFolder);
        this.prepare(this.fRootFolder.getAbsolutePath(), 1000);
        super.compileAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareDestinationFolder(File destFolder) throws DGCompilationFailedException {
        if (destFolder.exists()) {
            if (!destFolder.isDirectory()) throw new DGCompilationFailedException(12);
            if (!this.fFileSettings.shouldFlushDestination()) return;
            if (this.fProgressUI != null) {
                this.fProgressUI.ICompilerUI_setStatusMessage(new SimpleLocalizableMessage("Diagnos_Flushing_Target_Directory"));
            }
            try {
                this.flushDirectory(destFolder, true);
                return;
            }
            catch (DeletionFailedException dfe) {
                this.logException(dfe);
                if (this.fProgressUI == null) throw new DGCompilationFailedException(12);
                if (this.fProgressUI.ICompilerUI_handleException(dfe)) return;
                throw new DGCompilationFailedException(12);
            }
        } else {
            if (destFolder.mkdirs()) return;
            throw new DGCompilationFailedException(12);
        }
    }

    private void flushDirectory(File file, boolean skipTopLevel) throws DeletionFailedException {
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] files = file.list();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        File dirFile = new File(file, files[i]);
                        this.flushDirectory(dirFile, false);
                        ++i;
                    }
                }
                if (!skipTopLevel && !file.delete()) {
                    throw new DeletionFailedException(new FormattedLocalizableMessage("Diagnos_Exception_Deletion_Failed", file.getAbsolutePath(), false));
                }
            } else if (!(skipTopLevel || this.fFileSettings.skipFileDeletion(file) || file.delete())) {
                throw new DeletionFailedException(new FormattedLocalizableMessage("Diagnos_Exception_Deletion_Failed", file.getAbsolutePath(), false));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void compileClassFiles() throws DGCompilationFailedException {
        dir = ExtendedFile.safeGetCanonicalPath(this.fRootFolder);
        log = this.getLog();
        if (log != null) {
            log.ICompilerLog_startDirectory(dir);
        }
        if (this.fTraversal.hasAnotherSource()) ** GOTO lbl-1000
        this.logMessage("Directory contains no files");
        try lbl-1000:
        // 2 sources

        {
            block13: while (true) {
                if (!this.fTraversal.hasAnotherSource()) {
                    if (log == null) return;
                    log.ICompilerLog_finishDirectory(dir);
                    return;
                }
                this.pauseIfNecessary();
                if (this.shouldStop()) {
                    if (log != null) {
                        log.ICompilerLog_finishAborted(dir);
                    }
                    this.cancel();
                    return;
                }
                srcFile = this.fTraversal.getNextSource();
                destFile = this.fTraversal.getNextDest();
                try {
                    try {
                        if (this.isClassFile(srcFile)) {
                            this.handleClassFile(srcFile, destFile);
                            continue;
                        }
                        if (this.isZipFile(srcFile) || this.isJarFile(srcFile)) {
                            this.handleZipFile(srcFile, destFile);
                            continue;
                        }
                        this.handleGenericFile(srcFile, destFile);
                        continue;
                    }
                    catch (FileNotFoundException fnfe) {
                        this.logException(srcFile.getPath(), fnfe);
                        throw new DGCompilationFailedException(11);
                    }
                    catch (IOException ioe) {
                        this.logException(srcFile.getPath(), ioe);
                        if (this.fProgressUI == null) throw new DGCompilationFailedException(12);
                        this.fProgressUI.ICompilerUI_handleExceptionCopyingFile(srcFile.getPath(), ioe);
                        throw new DGCompilationFailedException(12);
                    }
                }
                catch (DGCompilationFailedException dgcfe) {
                    switch (dgcfe.getOption()) {
                        case 10: {
                            try {
                                this.fileCopy(srcFile, destFile);
                            }
                            catch (IOException ioe) {
                                this.logMessage("An error occurred while attempting to copy the file");
                                this.logException(srcFile.getPath(), ioe);
                            }
                            continue block13;
                        }
                        case 11: {
                            this.skipFile(srcFile.getPath());
                            continue block13;
                        }
                    }
                    throw dgcfe;
                }
                break;
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            if (log == null) throw dgcfe;
            log.ICompilerLog_finishException(dir);
            throw dgcfe;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleClassFile(File source, File dest) throws DGCompilationFailedException, IOException {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source), 16384);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new LazyFileOutputStream(dest), 16384);
                try {
                    this.compileClassFile(in, out, source.getName());
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            {
                Object var7_11 = null;
                ((InputStream)in).close();
                return;
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            switch (dgcfe.getOption()) {
                case 10: {
                    this.fileCopy(source, dest);
                    return;
                }
                case 11: {
                    this.skipFile(source.getPath());
                    return;
                }
            }
            throw dgcfe;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleZipFile(File source, File dest) throws DGCompilationFailedException, IOException {
        try {
            try {
                DGZipCompiler cmp = new DGZipCompiler(this.fSettings, this.fFileSettings, this.fProgressUI, this.getLog(), source, dest);
                cmp.setInterruptSource(this.getInterruptSource());
                cmp.compileAll();
            }
            catch (DGCompilationFailedException dgcfe) {
                switch (dgcfe.getOption()) {
                    case 10: {
                        this.fileCopy(source, dest);
                        break;
                    }
                    case 11: {
                        this.skipFile(source.getPath());
                        break;
                    }
                    default: {
                        throw dgcfe;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.setupUI();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.setupUI();
    }

    private void handleGenericFile(File source, File dest) throws DGCompilationFailedException, IOException {
        this.updateStatusBar(source.getName());
        if (this.fFileSettings.shouldCopyItems()) {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(source), 16384);
            this.copyToFile(source.getName(), input, dest);
            ((InputStream)input).close();
        } else {
            this.skipFile(source.getPath());
        }
    }

    protected void writeNewEntry(InputStream in, String path) throws DGCompilationFailedException, IOException {
        path = path.replace('/', File.separatorChar);
        File outFile = new File(this.fDestFolder, path);
        if (path.endsWith(File.separator)) {
            outFile.mkdirs();
            return;
        }
        this.copyToFile(path, in, outFile);
    }

    static class LiveTraversal {
        private File fInitialDestination;
        private DGFileSettings fFileSettings;
        private Stack fDirectories;
        private boolean fIncludeSubFolders;
        private File fNextSource;
        private File fNextDest;

        public LiveTraversal(DGFileSettings fileSettings, File sourceFolder, File destFolder, boolean includeSubFolders) {
            this.fInitialDestination = destFolder;
            this.fFileSettings = fileSettings;
            this.fDirectories = new Stack();
            this.fDirectories.push(new StackElement(sourceFolder, destFolder, sourceFolder.list()));
            this.fIncludeSubFolders = includeSubFolders;
            this.fNextSource = null;
            this.fNextDest = null;
        }

        private void getNextElement() throws DGCompilationFailedException {
            while (!this.fDirectories.empty()) {
                boolean finishedDirectory = true;
                StackElement directory = (StackElement)this.fDirectories.peek();
                while (directory.fCurIndex < directory.fFiles.length) {
                    ExtendedFile source = new ExtendedFile(directory.fSourceFolder, directory.fFiles[directory.fCurIndex]);
                    ExtendedFile dest = new ExtendedFile(directory.fDestFolder, directory.fFiles[directory.fCurIndex]);
                    ++directory.fCurIndex;
                    if (source.canonicalEquals(this.fInitialDestination) || this.fFileSettings.shouldIgnoreFile(source.getFile())) continue;
                    if (source.isDirectory()) {
                        if (!this.fIncludeSubFolders) continue;
                        if (dest.exists() || dest.mkdir()) {
                            this.fDirectories.push(new StackElement(source.getFile(), dest.getFile(), source.list()));
                            finishedDirectory = false;
                            break;
                        }
                        throw new DGCompilationFailedException(12);
                    }
                    this.fNextSource = source.getFile();
                    this.fNextDest = dest.getFile();
                    return;
                }
                if (!finishedDirectory) continue;
                this.fDirectories.pop();
            }
        }

        public boolean hasAnotherSource() throws DGCompilationFailedException {
            if (this.fNextSource == null) {
                this.getNextElement();
            }
            return this.fNextSource != null;
        }

        public File getNextSource() throws DGCompilationFailedException {
            if (this.fNextSource == null) {
                this.getNextElement();
            }
            File result = this.fNextSource;
            this.fNextSource = null;
            return result;
        }

        public boolean hasAnotherDest() throws DGCompilationFailedException {
            if (this.fNextDest == null) {
                this.getNextElement();
            }
            return this.fNextDest != null;
        }

        public File getNextDest() throws DGCompilationFailedException {
            if (this.fNextDest == null) {
                this.getNextElement();
            }
            File result = this.fNextDest;
            this.fNextDest = null;
            return result;
        }
    }

    static class StackElement {
        public File fSourceFolder;
        public File fDestFolder;
        public String[] fFiles;
        public int fCurIndex;

        public StackElement(File sourceFolder, File destFolder, String[] files) {
            this.fSourceFolder = sourceFolder;
            this.fDestFolder = destFolder;
            this.fFiles = files;
            this.fCurIndex = 0;
        }
    }
}

