/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.ConnectionThread;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.net.Socket;

class FailbackTask
implements ITimestampedRunnable {
    private static Module sModule = new Module("Failback Task");
    private final IServerFailoverPolicy fFailoverPolicy;
    private final ConnectionThread fConnectionThread;
    private final IsengardServerConnectionManager fConnectionManager;
    private final IntervalHeartbeat fHeartbeat;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private IRegisteredBehavior fHandle;
    private static int attemptCounter;
    private static final int kMaxAttempt = 10;

    public FailbackTask(IServerFailoverPolicy failoverPolicy, ConnectionThread connectionThread, IsengardServerConnectionManager connectionManager, IntervalHeartbeat heartbeat) {
        this.fFailoverPolicy = failoverPolicy;
        this.fConnectionThread = connectionThread;
        this.fConnectionManager = connectionManager;
        this.fHeartbeat = heartbeat;
        this.fFeedback = connectionManager.getFeedbackChannel();
        this.fLocalizer = connectionManager.getStringLocalizer();
    }

    public void scheduleFailbackAttempts() {
        this.fConnectionThread.setFailbackScheduled(true);
        long interval = this.fFailoverPolicy.getFailbackRetryIntervalInSeconds() * 1000;
        this.setHandle(this.fHeartbeat.addBehavior((ITimestampedRunnable)this, "Failback Task", true, interval, false));
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (!this.isHandleSet()) {
            return;
        }
        if (this.isPrimaryEMAvailable(this.fFailoverPolicy.getFailbackServer())) {
            this.fConnectionManager.addConnectionObserver(new FailbackStateNotification(this.fConnectionManager));
            this.fFailoverPolicy.notifyOfSuccessfulFailbackConnection();
            this.fConnectionThread.setFailbackScheduled(false);
            this.disconnectFromFailoverEM();
            this.fHeartbeat.removeBehavior(this.getHandle());
            attemptCounter = 0;
        } else if (++attemptCounter <= 10) {
            this.fFeedback.info(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Reconnect_Failed_Message", this.fFailoverPolicy.getFailbackServer().toString(), Integer.toString(attemptCounter)));
            if (attemptCounter == 10) {
                this.fFeedback.info(sModule, this.fLocalizer.IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reconnect_Logging_Stopped_Message"));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPrimaryEMAvailable(ServerInstanceLocator serverLocator) {
        boolean isAvailable = false;
        Socket socket = null;
        try {
            try {
                socket = new Socket(serverLocator.getHostName(), serverLocator.getPort());
                isAvailable = true;
                this.fFeedback.info(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Connection_Established_Message", serverLocator.toString()));
            }
            catch (Exception exception) {
                if (this.fFeedback.isTraceEnabled(sModule)) {
                    this.fFeedback.trace(sModule, "Primary EM not available: " + serverLocator);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeSocket(socket);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeSocket(socket);
            return isAvailable;
        }
    }

    private void disconnectFromFailoverEM() {
        this.fConnectionThread.setLostConnection(true);
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized boolean isHandleSet() {
        return this.getHandle() != null;
    }

    private synchronized IRegisteredBehavior getHandle() {
        return this.fHandle;
    }

    private synchronized void setHandle(IRegisteredBehavior handle) {
        this.fHandle = handle;
    }

    private static class FailbackStateNotification
    implements IServerConnectionNotification {
        private final IsengardServerConnectionManager fConnectionManager;
        private final ServerInstanceLocator fPrimaryEM;
        private final ServerInstanceLocator fFailoverEM;
        private final IModuleFeedbackChannel fFeedback;
        private final IStringLocalizer fLocalizer;

        public FailbackStateNotification(IsengardServerConnectionManager connectionManager) {
            this.fConnectionManager = connectionManager;
            this.fPrimaryEM = connectionManager.getFailoverPolicy().getFailbackServer();
            this.fFailoverEM = connectionManager.getCurrentServer();
            this.fFeedback = connectionManager.getFeedbackChannel();
            this.fLocalizer = connectionManager.getStringLocalizer();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void connectionUp() {
            try {
                if (this.fConnectionManager.isConnectedToPrimaryEM()) {
                    this.fFeedback.info(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Successful_Message", this.fPrimaryEM.toString()));
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fConnectionManager.removeConnectionObserver(this);
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fConnectionManager.removeConnectionObserver(this);
                return;
            }
        }

        public void connectionDown() {
            this.fFeedback.info(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Cleanly_Disconnected_Message", this.fFailoverEM.toString()));
        }
    }
}

