/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.transactiontrace.CrossJVMSympatheticTransactionTraceFilter;
import com.wily.introscope.agent.transactiontrace.FirstNPerIntervalSamplingFilter;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceFilterChangeListener;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.agent.transactiontrace.TransactionRecordingBlameStackAllocator;
import com.wily.introscope.agent.transactiontrace.URLSamplingTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.KTransactionTraceConstants;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class TransactionTraceController
implements ITransactionTraceListener {
    private volatile int fDynamicFilterCount;
    private final TransactionRecordingBlameStackAllocator fAllocator;
    private final ITransactionTraceListener fListener;
    private final MetricRecordingAdministrator fAdministrator;
    private final IntervalHeartbeat fHeartbeat;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ITransactionEnvironment fTransactionEnv;
    private FilterRepository fFilterRepository;
    private int fReportingLimit;
    private int fReportedTransactions;
    private boolean fLoggedOverLimit;
    private FirstNPerIntervalSamplingFilter fFirstNPerIntervalSamplingFilter;
    private WeakHashSet fFilterChangeListeners;
    private final Set fSupportedFilterTypes;
    private static boolean fbHasBeenClamped = false;
    private final Object fFilterLock = new Object();
    private final Object fReportingLock = new Object();
    private final Object fListenerLock = new Object();
    private IAgent fAgent;
    private volatile boolean fAreFiltersInitialized = false;
    private static final int kReportingLimitPeriodInSeconds = 15;
    private static final int kDefaultReportingLimit = 200;
    private static Module fModule;
    private TransactionPropagationConfigurationProperty fIsTailFilterPropagateEnabledProperty;
    private volatile boolean fIsSessionEnabled;

    public TransactionTraceController(ConfigurationManager configManager, Module module, ITransactionTraceListener listener, IAgent agent, MetricRecordingAdministrator administrator, ComponentTracer componentTracer, IntervalHeartbeat heartbeat, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fAgent = agent;
        this.fAllocator = new TransactionRecordingBlameStackAllocator(agent, configManager, module, feedback, localizer, this, new ITransactionTraceFilter[0], componentTracer);
        this.fListener = listener;
        this.fAdministrator = administrator;
        this.fHeartbeat = heartbeat;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fTransactionEnv = componentTracer;
        this.loadConfiguration(this.fAgent.IAgent_getIndexedProperties());
        this.fAreFiltersInitialized = false;
        this.fHeartbeat.addBehavior((ITimestampedRunnable)new ReportingLimitResetBehavior(), "Reporting Limit Reset Behavior", true, 15000L, true);
        this.fFilterRepository = new FilterRepository();
        this.fReportedTransactions = 0;
        this.fLoggedOverLimit = false;
        this.fDynamicFilterCount = 0;
        this.fSupportedFilterTypes = new HashSet();
        this.addDefaultFilterTypes();
        this.fFilterChangeListeners = new WeakHashSet();
        fModule = module;
        this.fIsTailFilterPropagateEnabledProperty = new TransactionPropagationConfigurationProperty(agent);
        this.fAgent.IAgent_getConfigurationManager().add(this.fIsTailFilterPropagateEnabledProperty, true);
        SessionIdPropagationConfigurationProperty sessionIdPropagateProperty = new SessionIdPropagationConfigurationProperty(agent);
        this.fAgent.IAgent_getConfigurationManager().add(sessionIdPropagateProperty, true);
    }

    private void addDefaultFilterTypes() {
        int i = 0;
        while (i < KTransactionTraceConstants.kAgentTransactionTraceFilterTypes.length) {
            this.fSupportedFilterTypes.add(new Integer(KTransactionTraceConstants.kAgentTransactionTraceFilterTypes[i]));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransactionTraceFilterChangeListener(ITransactionTraceFilterChangeListener listener) {
        Object object = this.getListenerLock();
        synchronized (object) {
            this.fFilterChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterTransactionTraceFilterChangeListener(ITransactionTraceFilterChangeListener listener) {
        boolean res = false;
        Object object = this.getListenerLock();
        synchronized (object) {
            res = this.fFilterChangeListeners.remove(listener);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstNonPermanentFilterIndex() {
        Object object = this.getFilterLock();
        synchronized (object) {
            return this.fFilterRepository.getFirstNonPermanentFilterIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionTraceFilter getFilterAt(int index) {
        Object object = this.getFilterLock();
        synchronized (object) {
            if (index >= this.fFilterRepository.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return (ITransactionTraceFilter)this.fFilterRepository.get(index);
        }
    }

    public long getLastUpdatedPermanentFilters() {
        if (this.fAreFiltersInitialized) {
            return this.fFilterRepository.lastUpdatedPermanent;
        }
        return 0L;
    }

    public Set getPermanentFilters() {
        if (this.fAreFiltersInitialized) {
            return new HashSet(this.fFilterRepository.getPermanentFilters());
        }
        return new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializePermanentFilters() {
        Object object = this.getFilterLock();
        synchronized (object) {
            if (!this.fAreFiltersInitialized) {
                this.getModuleFeedback().debug("Initializing Permanent Filters");
                boolean shouldSample = this.fAgent.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.agent.transactiontracer.sampling.enabled", true, this.fFeedback, this.fLocalizer);
                if (shouldSample) {
                    this.fFilterRepository.addPermanent(new URLSamplingTransactionTraceFilter(this.fFeedback, this.fLocalizer, this.fAgent));
                    this.fFirstNPerIntervalSamplingFilter = new FirstNPerIntervalSamplingFilter(this.fHeartbeat, this.fAgent.IAgent_getIndexedProperties(), this.fTransactionEnv, this.getModuleFeedback(), this.getStringLocalizer());
                    this.fFilterRepository.addPermanent(this.fFirstNPerIntervalSamplingFilter);
                    this.fFeedback.info("Started transaction sampling service");
                }
                this.fFilterRepository.addPermanent(new CrossJVMSympatheticTransactionTraceFilter(this.fFeedback, this.fTransactionEnv));
                this.fAreFiltersInitialized = true;
                this.updateAllocator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTSamplingProperties(long samplingInterval, int samplesPerInterval) {
        if (!this.isTransactionTracingSetInAgent()) {
            this.initializePermanentFilters();
        }
        if (this.fFirstNPerIntervalSamplingFilter == null) {
            this.getModuleFeedback().debug("TT Sampling not initialized");
            return;
        }
        if (samplingInterval <= 0L) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Sampling_Interval_Negative_Value_Message", String.valueOf(samplingInterval)));
        }
        if (samplesPerInterval <= 0) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Samples_Per_Interval_Negative_Value_Message", String.valueOf(samplesPerInterval)));
        }
        if (samplingInterval > 0L || samplesPerInterval > 0) {
            Object object = this.getFilterLock();
            synchronized (object) {
                if (samplingInterval > 0L) {
                    this.fFirstNPerIntervalSamplingFilter.updateSamplingInteval(samplingInterval);
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Sampling_Interval_Set_Message", String.valueOf(samplingInterval)));
                }
                if (samplesPerInterval > 0) {
                    this.fFirstNPerIntervalSamplingFilter.updateSamplesPerInterval(samplesPerInterval);
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Samples_Per_Interval_Set_Message", String.valueOf(samplesPerInterval)));
                }
                this.updateAllocator();
            }
        }
    }

    public boolean isTransactionTracingSetInAgent() {
        if (this.fFirstNPerIntervalSamplingFilter == null) {
            return false;
        }
        return this.fFirstNPerIntervalSamplingFilter.isSamplingSetInAgentProperties();
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private Object getFilterLock() {
        return this.fFilterLock;
    }

    private Object getReportingLock() {
        return this.fReportingLock;
    }

    public static boolean getHasBeenClamped() {
        return fbHasBeenClamped;
    }

    private Object getListenerLock() {
        return this.fListenerLock;
    }

    public void loadConfiguration(IndexedProperties properties) {
        this.fReportingLimit = this.loadReportingLimit(properties);
    }

    private int loadReportingLimit(IndexedProperties properties) {
        int reportingLimit = 200;
        if (properties.getProperty("introscope.agent.transactiontracer.antifloodthreshold") != null) {
            reportingLimit = properties.safeGetPositiveIntProperty("introscope.agent.transactiontracer.antifloodthreshold", 200, this.getModuleFeedback(), this.getStringLocalizer());
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Reporting_Limit_Configured", String.valueOf(reportingLimit), String.valueOf(15)));
        }
        return reportingLimit;
    }

    public void registerTransactionTraceFilterType(int type) {
        this.fSupportedFilterTypes.add(new Integer(type));
    }

    public Set getSupportedTransactionTraceFilterTypes() {
        return Collections.unmodifiableSet(this.fSupportedFilterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterCount() {
        Object object = this.getFilterLock();
        synchronized (object) {
            return this.fFilterRepository.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionTraceFilter[] getCurrentlyActiveTransactionTraceFilters() {
        ITransactionTraceFilter[] tranTraceFilterArr = null;
        int size = 0;
        Object object = this.getFilterLock();
        synchronized (object) {
            if (this.fFilterRepository != null) {
                size = this.fFilterRepository.size();
            }
            tranTraceFilterArr = new ITransactionTraceFilter[size];
            int i = 0;
            while (i < size) {
                tranTraceFilterArr[i] = (ITransactionTraceFilter)this.fFilterRepository.get(i);
                ++i;
            }
            return tranTraceFilterArr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(ITransactionTraceFilter filter) {
        if (this.getModuleFeedback().isDebugEnabled()) {
            this.getModuleFeedback().debug("addFilter: " + filter);
        }
        Object object = this.getFilterLock();
        synchronized (object) {
            this.fFilterRepository.addPermanent(filter);
            this.updateAllocator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEMFilter(ITransactionTraceFilter filter) {
        if (this.getModuleFeedback().isDebugEnabled()) {
            this.getModuleFeedback().debug("addEMFilter: " + filter);
        }
        if (!this.isTransactionTracingSetInAgent()) {
            this.initializePermanentFilters();
        }
        Object object = this.getFilterLock();
        synchronized (object) {
            this.fFilterRepository.addTransient(filter);
            this.updateAllocator();
            ++this.fDynamicFilterCount;
        }
        HashSet iterateOn = null;
        Object object2 = this.getListenerLock();
        synchronized (object2) {
            if (this.fFilterChangeListeners.size() > 0) {
                iterateOn = new HashSet(this.fFilterChangeListeners.keySet());
            }
        }
        if (iterateOn != null) {
            Iterator it = iterateOn.iterator();
            while (it.hasNext()) {
                ITransactionTraceFilterChangeListener listener = (ITransactionTraceFilterChangeListener)it.next();
                listener.sessionFilterAdd(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(ITransactionTraceFilter filter) {
        if (this.getModuleFeedback().isDebugEnabled()) {
            this.getModuleFeedback().debug("removeFilter: " + filter);
        }
        Object object = this.getFilterLock();
        synchronized (object) {
            this.fFilterRepository.remove(filter);
            this.updateAllocator();
            --this.fDynamicFilterCount;
        }
        HashSet iterateOn = null;
        Object object2 = this.getListenerLock();
        synchronized (object2) {
            if (this.fFilterChangeListeners.size() > 0) {
                iterateOn = new HashSet(this.fFilterChangeListeners.keySet());
            }
        }
        if (iterateOn != null) {
            Iterator it = iterateOn.iterator();
            while (it.hasNext()) {
                ITransactionTraceFilterChangeListener listener = (ITransactionTraceFilterChangeListener)it.next();
                listener.sessionFilterRemove(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDynamicFilterPresence() {
        boolean dynamicPresenceStatus = false;
        Object object = this.getFilterLock();
        synchronized (object) {
            if (this.fDynamicFilterCount > 0) {
                dynamicPresenceStatus = true;
            }
        }
        return dynamicPresenceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        this.getModuleFeedback().debug("stopRecording");
        Object object = this.getFilterLock();
        synchronized (object) {
            this.fFilterRepository.removeTransient();
            this.fAllocator.setFilters(new ITransactionTraceFilter[0]);
        }
        HashSet iterateOn = null;
        Object object2 = this.getListenerLock();
        synchronized (object2) {
            if (this.fFilterChangeListeners.size() > 0) {
                iterateOn = new HashSet(this.fFilterChangeListeners.keySet());
            }
        }
        if (iterateOn != null) {
            Iterator it = iterateOn.iterator();
            while (it.hasNext()) {
                ITransactionTraceFilterChangeListener listener = (ITransactionTraceFilterChangeListener)it.next();
                listener.sessionFilterReset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartRecording() {
        this.getModuleFeedback().debug("restartRecording");
        Object object = this.getFilterLock();
        synchronized (object) {
            this.initializePermanentFilters();
        }
    }

    private void updateAllocator() {
        if (this.getModuleFeedback().isDebugEnabled()) {
            this.getModuleFeedback().debug("Update Allocator with Filter Repository: " + this.fFilterRepository);
        }
        ITransactionTraceFilter[] snapshot = new ITransactionTraceFilter[this.fFilterRepository.size()];
        snapshot = this.fFilterRepository.toArray(snapshot);
        this.fAllocator.setFilters(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITransactionTraceListener_reportTransaction(TransactionComponentData root) {
        if (!this.fAdministrator.getGlobalShutOff()) {
            boolean willNotExceedReportingLimit = false;
            boolean shouldLog = false;
            Object object = this.getReportingLock();
            synchronized (object) {
                if (this.fReportedTransactions < this.fReportingLimit) {
                    ++this.fReportedTransactions;
                    willNotExceedReportingLimit = true;
                } else {
                    if (!this.fLoggedOverLimit) {
                        shouldLog = true;
                        this.fLoggedOverLimit = true;
                        fbHasBeenClamped = true;
                    }
                    willNotExceedReportingLimit = false;
                    String typeValue = root.getParameterValue("Trace Type");
                    if ("Sampled".equals(typeValue) && this.fFilterRepository.size() > 0 && this.fFilterRepository.get(0) instanceof URLSamplingTransactionTraceFilter) {
                        URLSamplingTransactionTraceFilter sampler = (URLSamplingTransactionTraceFilter)this.fFilterRepository.get(0);
                        String url = root.getParameterValue("Normalized URL");
                        sampler.clearSingleEntry(url);
                    }
                }
            }
            if (willNotExceedReportingLimit) {
                this.fListener.ITransactionTraceListener_reportTransaction(root);
            }
            if (shouldLog) {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Reporting_Limit_Reached", String.valueOf(this.fReportingLimit), String.valueOf(15)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReportedTransactionCount() {
        Object object = this.getReportingLock();
        synchronized (object) {
            this.fReportedTransactions = 0;
            this.fLoggedOverLimit = false;
            fbHasBeenClamped = false;
        }
    }

    public TransactionRecordingBlameStackAllocator getBlameStackAllocator() {
        return this.fAllocator;
    }

    public boolean isTailFilterPropagationEnabled() {
        return this.fIsTailFilterPropagateEnabledProperty.isEnabled();
    }

    public boolean isSessionIdPropagationEnabled() {
        return this.fIsSessionEnabled;
    }

    class FilterRepository
    extends ArrayList {
        private Set permanent;
        public volatile long lastUpdatedPermanent = System.currentTimeMillis();

        FilterRepository() {
            this.permanent = new HashSet();
        }

        public Object remove(int index) {
            this.lastUpdatedPermanent = System.currentTimeMillis();
            Object removed = super.remove(index);
            this.permanent.remove(removed);
            return removed;
        }

        public boolean remove(Object filter) {
            this.lastUpdatedPermanent = System.currentTimeMillis();
            boolean isRemoved = super.remove(filter);
            this.permanent.remove(filter);
            return isRemoved;
        }

        public void addPermanent(ITransactionTraceFilter filter) {
            this.lastUpdatedPermanent = System.currentTimeMillis();
            super.add(filter);
            this.permanent.add(filter);
        }

        public void addTransient(ITransactionTraceFilter filter) {
            this.lastUpdatedPermanent = System.currentTimeMillis();
            super.add(filter);
            this.permanent.remove(filter);
        }

        public Set getPermanentFilters() {
            return this.permanent;
        }

        public int getFirstNonPermanentFilterIndex() {
            int i = 0;
            while (i < this.size()) {
                if (!this.permanent.contains(this.get(i))) {
                    return i;
                }
                ++i;
            }
            return this.size();
        }

        public void removeTransient() {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Object filter = i.next();
                if (this.permanent.contains(filter)) continue;
                this.lastUpdatedPermanent = System.currentTimeMillis();
                i.remove();
            }
        }

        public String toString() {
            return String.valueOf(super.toString()) + ", permanent: " + this.permanent + ", last updated: " + this.lastUpdatedPermanent;
        }
    }

    private final class ReportingLimitResetBehavior
    implements ITimestampedRunnable {
        private ReportingLimitResetBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            TransactionTraceController.this.resetReportedTransactionCount();
        }
    }

    private final class SessionIdPropagationConfigurationProperty
    extends BooleanConfigurationProperty {
        private SessionIdPropagationConfigurationProperty(IAgent agent) {
            super("introscope.agent.transactiontracer.parameter.capture.sessionid", Boolean.TRUE, "Hot_Property_Configuration_Property", true, false, agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            TransactionTraceController.this.fIsSessionEnabled = (Boolean)newValue;
        }
    }

    private final class TransactionPropagationConfigurationProperty
    extends BooleanConfigurationProperty {
        boolean value;

        private TransactionPropagationConfigurationProperty(IAgent agent) {
            super("introscope.agent.transactiontracer.tailfilterPropagate.enable", new Boolean(true), agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }
}

