/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.beans.loadbalancing;

import com.wily.introscope.spec.server.beans.loadbalancing.ReconnectInfo;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AdvancedReconnectInfo
implements IConstructorExternalizable {
    private int fFlags;
    private ReconnectInfo[] fCollectorList;
    private long fTimestamp;
    private static final int kThisComesFromAMom = 1;
    private static final int kStayConnected = 2;
    private static final int kAllowDataSend = 4;

    private AdvancedReconnectInfo(ReconnectInfo[] info, long timeStamp) {
        this.fCollectorList = new ReconnectInfo[info.length];
        System.arraycopy(info, 0, this.fCollectorList, 0, info.length);
        this.fFlags = 4;
        this.fTimestamp = timeStamp;
    }

    private AdvancedReconnectInfo(ReconnectInfo[] info, boolean isMom, long timeStamp) {
        this(info, timeStamp);
        this.setIsMom(isMom);
    }

    private AdvancedReconnectInfo(ReconnectInfo[] info, boolean isMom, boolean stayConnected, long timeStamp) {
        this(info, isMom, timeStamp);
        this.setStayConnected(stayConnected);
    }

    public AdvancedReconnectInfo(ReconnectInfo[] info, boolean isMom, boolean stayConnected, boolean allowSend, long timeStamp) {
        this(info, isMom, stayConnected, timeStamp);
        this.setAllowSend(allowSend);
    }

    public AdvancedReconnectInfo(ObjectInput in) throws IOException {
        this.fFlags = in.readInt();
        this.fTimestamp = in.readLong();
        this.fCollectorList = new ReconnectInfo[in.readInt()];
        try {
            int entryNum = 0;
            while (entryNum < this.fCollectorList.length) {
                this.fCollectorList[entryNum] = (ReconnectInfo)in.readObject();
                ++entryNum;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fFlags);
        out.writeLong(this.fTimestamp);
        out.writeInt(this.fCollectorList.length);
        int entryNum = 0;
        while (entryNum < this.fCollectorList.length) {
            out.writeObject(this.fCollectorList[entryNum]);
            ++entryNum;
        }
    }

    public void setIsMom(boolean isMom) {
        this.setBit(isMom, 1);
    }

    public boolean getIsMom() {
        return (this.fFlags & 1) != 0;
    }

    public void setStayConnected(boolean stayConnected) {
        this.setBit(stayConnected, 2);
    }

    public boolean getStayConnected() {
        return (this.fFlags & 2) != 0;
    }

    public void setAllowSend(boolean allow) {
        this.setBit(allow, 4);
    }

    public boolean getAllowSend() {
        return (this.fFlags & 4) != 0;
    }

    public ReconnectInfo getConnection(int id) {
        if (this.fCollectorList == null || id < 0 || id >= this.fCollectorList.length) {
            return null;
        }
        return this.fCollectorList[id];
    }

    public int getNumConnections() {
        return this.fCollectorList.length;
    }

    private void setBit(boolean flag, int bit) {
        this.fFlags = flag ? (this.fFlags |= bit) : (this.fFlags &= ~bit);
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("{");
        int i = 0;
        while (i < this.fCollectorList.length) {
            ReconnectInfo collector = this.fCollectorList[i];
            info.append(collector.toString());
            info.append(", ");
            ++i;
        }
        info.append("}@");
        info.append(this.getTimestamp());
        return info.toString();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public ReconnectInfo[] getReconnectInfos() {
        return this.fCollectorList;
    }
}

