/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.IMessageReplyTimeout;
import com.wily.isengard.messageprimitives.service.IllegalAccessException;
import com.wily.isengard.messageprimitives.service.IllegalServiceAccessException;
import com.wily.isengard.messageprimitives.service.MessageServiceClient;
import com.wily.isengard.messageprimitives.service.MessageServiceInfo;
import com.wily.isengard.messageprimitives.service.Messages;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.messageprimitives.service.ServiceNotFoundException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;

public final class MessageServiceFactory {
    private static final char kRootPath = '/';

    private MessageServiceFactory() {
    }

    public static final Object getInterface(PostOffice po, Class interfaceClass) throws ConnectionException, IllegalServiceAccessException {
        return MessageServiceFactory.getInterface(po, interfaceClass, null);
    }

    public static final Object getInterface(PostOffice po, Class interfaceClass, MessageServiceInfo info) throws ConnectionException, IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, info);
    }

    public static final Object getInterface(PostOffice po, Class interfaceClass, String location) throws ConnectionException, IllegalServiceAccessException {
        try {
            return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, location, null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalServiceAccessException(Messages.getString("MessageServiceFactory.IllegalServiceAccessException"), e);
        }
        catch (ServiceException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static final Object getServiceSafe(PostOffice po, Class interfaceClass) {
        try {
            return MessageServiceFactory.getService(po, interfaceClass);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static final Object getServiceSafe(PostOffice po, Class interfaceClass, String location) {
        try {
            return MessageServiceFactory.getService(po, interfaceClass, location);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static final Object getService(PostOffice po, Class interfaceClass) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, null);
    }

    public static final Object getService(PostOffice po, Class interfaceClass, IMessageReplyTimeout timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, timeout);
    }

    public static final Object getService(PostOffice po, Class interfaceClass, long timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, timeout);
    }

    public static final Object getService(PostOffice po, Class interfaceClass, String location) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, location, null);
    }

    public static final Object getService(PostOffice po, Class interfaceClass, Address address) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, address, 600000L);
    }

    public static final Object getService(PostOffice po, Class interfaceClass, Address address, long timeout) throws IllegalServiceAccessException {
        if (address.getInvocationHandler() != null) {
            return address.getInvocationHandler();
        }
        MessageServiceClient client = new MessageServiceClient(po, interfaceClass, address, timeout);
        return client.proxyInterface();
    }

    public static final Object getService(PostOffice po, Class interfaceClass, MessageServiceInfo serviceInfo) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, serviceInfo.getServiceAddress());
    }

    public static final Object getService(PostOffice po, Class interfaceClass, MessageServiceInfo serviceInfo, long timeout) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, serviceInfo.getServiceAddress(), timeout);
    }

    private static final Object internalGetServiceInterface(PostOffice po, Class interfaceClass, String relativeServiceName, long timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, relativeServiceName, timeout, null);
    }

    private static final Object internalGetServiceInterface(PostOffice po, Class interfaceClass, String relativeServiceName, IMessageReplyTimeout timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, relativeServiceName, -1L, timeout);
    }

    private static final Object internalGetServiceInterface(PostOffice po, Class interfaceClass, String relativeServiceName, long timeout, IMessageReplyTimeout timeoutCallback) throws ConnectionException, ServiceException {
        if (po == null) {
            throw new ConnectionException(Messages.getString("MessageServiceFactory.NoPostOfficeSpecifiedException"));
        }
        String absoluteServiceName = relativeServiceName != null ? "/service/" + interfaceClass.getName() + "/" + relativeServiceName : "/service/" + interfaceClass.getName();
        try {
            IRegistryService regClient = po.getRegistry();
            RegistryEntry entry = regClient.getEntry(new DirectoryPath(absoluteServiceName));
            Address address = entry.getAddress();
            if (address != null && address.getInvocationHandler() != null) {
                return address.getInvocationHandler();
            }
            MessageServiceClient client = null;
            client = timeoutCallback != null ? new MessageServiceClient(po, interfaceClass, address, timeoutCallback) : (timeout != -1L ? new MessageServiceClient(po, interfaceClass, address, timeout) : new MessageServiceClient(po, interfaceClass, address));
            return client.proxyInterface();
        }
        catch (IllegalServiceAccessException e) {
            throw new IllegalAccessException(Messages.getString("MessageServiceFactory.IllegalServiceAccessException"), e);
        }
        catch (InvalidPathException invalidPathException) {
            throw new ServiceNotFoundException(Messages.getString("MessageServiceFactory.InvalidRegistryPathException"), new EntryNotFoundException(absoluteServiceName));
        }
        catch (EntryNotFoundException e) {
            throw new ServiceNotFoundException(Messages.getString("MessageServiceFactory.EntryNotFoundException"), e);
        }
    }
}

