/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtilities {
    private TreeUtilities() {
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtilities.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreeUtilities.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static TreeNode findChildNodeByName(TreeNode parentNode, String childName) {
        int childCount = parentNode.getChildCount();
        TreeNode targetChild = null;
        for (int i = 0; i < childCount && targetChild == null; ++i) {
            TreeNode candidateChild = parentNode.getChildAt(i);
            if (!childName.equals(candidateChild.toString())) continue;
            targetChild = candidateChild;
        }
        return targetChild;
    }
}

