/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IFieldName;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidFieldNameException;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.ClassFileValidationUtilities;
import com.wily.util.text.FormattedLocalizableMessage;

public final class FieldName
implements IFieldName {
    private final String fFieldName;
    private final ClassFileFieldDescriptor fFieldDescriptor;

    private FieldName(String fieldName, ClassFileFieldDescriptor fieldDescriptor) {
        this.fFieldName = fieldName;
        this.fFieldDescriptor = fieldDescriptor;
    }

    public boolean hasSignature() {
        return this.fFieldDescriptor != null;
    }

    public ISlotSignature getSignature() {
        return this.fFieldDescriptor;
    }

    public String getNameString() {
        return this.fFieldName;
    }

    public String toString() {
        return this.getNameString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldName) {
            FieldName typed = (FieldName)obj;
            return this.getNameString().equals(typed.getNameString()) && this.hasSignature() == typed.hasSignature() && this.getSignature().equals(typed.getSignature());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, this.fFieldName);
        result = HashCodeUtils.accumulateHashCode(result, this.fFieldDescriptor);
        return result;
    }

    public static FieldName getFieldName(String name) throws InvalidFieldDescriptorException, InvalidFieldNameException {
        return FieldName.getFieldName(name, null);
    }

    public static FieldName getFieldName(String name, ClassFileFieldDescriptor descriptor) throws InvalidFieldDescriptorException, InvalidFieldNameException {
        try {
            ClassFileValidationUtilities.validateSimpleJavaIdentifier(name);
        }
        catch (InvalidIdentifierException iie) {
            throw new InvalidFieldNameException(new FormattedLocalizableMessage("Class_File_Invalid_Field_Name", name), name);
        }
        return new FieldName(name, descriptor);
    }
}

