/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.messageprimitives.service.ServiceNotFoundException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.rave.agent.AgentBeanParamContainer;
import com.wily.rave.agent.IConnectionUpListener;
import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.server.api.IAgentServiceLocator;
import com.wily.rave.server.api.IWatchedAgent;
import com.wily.rave.utils.IsengardClassloaderRegistrator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

class ConnectionManager
implements IServerConnectionNotification {
    private boolean destroyed;
    private String watchedAgentSvcName;
    private RaveAgent raveAgent;
    private IAgent agent;
    private IModuleFeedbackChannel feedback;
    private Collection connectionListeners;
    private Collection connectedProxies;
    private int connUpCounter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionManager(RaveAgent raveAgent, IAgent agent, IModuleFeedbackChannel feedback) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.agent = agent;
            this.raveAgent = raveAgent;
            this.agent.IAgent_getIsengardServerConnection().addConnectionObserver((IServerConnectionNotification)this);
            this.feedback = feedback;
            this.connectionListeners = new LinkedList();
            this.connectedProxies = new HashSet();
            this.connUpCounter = 0;
        }
    }

    private final void checkDestroyed() {
        if (!this.destroyed) {
            return;
        }
        throw new StopCollectionException("The connection manager has been destroyed (most likely the ChangeDetector agent extension has been shutdown)!");
    }

    IWatchedAgent getWatchedAgentBean() {
        try {
            return this.getWatchedAgentBeanInternal();
        }
        catch (StopChangeDetectorExtensionException stopChangeDetectorExtensionException) {
            this.raveAgent.shutDown();
            throw new StopCollectionException("ChangeDetector agent extension shutting down.");
        }
    }

    synchronized boolean staleWatchedAgentBean(IWatchedAgent watchedAgentBean) {
        return !this.connectedProxies.contains(new ProxyWrapper(watchedAgentBean));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IWatchedAgent getWatchedAgentBeanInternal() throws StopChangeDetectorExtensionException {
        int beanFetchAttempts = 0;
        int pause = 0;
        while (true) {
            if (pause != 0) {
                this.pause(pause);
                pause = 0;
            }
            ConnectedServer srvConn = this.getIsengardConnection();
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.checkDestroyed();
                try {
                    IWatchedAgent conn;
                    PostOffice po = srvConn.getPostOffice();
                    if (this.watchedAgentSvcName == null) {
                        this.feedback.info("Creating server comm channel...");
                        IAgentServiceLocator agentRegSvc = null;
                        IsengardClassloaderRegistrator.setClassloaderOnHub((PostOfficeHub)po.getPostOfficeHub());
                        try {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.wily.rave.server.api.IAgentServiceLocator");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            agentRegSvc = (IAgentServiceLocator)MessageServiceFactory.getService((PostOffice)po, (Class)clazz);
                        }
                        catch (ServiceNotFoundException ex) {
                            if (beanFetchAttempts < 1) {
                                ++beanFetchAttempts;
                                this.feedback.warn("Failed to locate server side services, attempting once more...");
                                pause = this.raveAgent.getRaveConfig().getWaitTimeBetweenConnectsInSec();
                                continue;
                            }
                            String msg = "ChangeDetector server component not available in EM. ChangeDetector agent extension will shut down!";
                            this.feedback.error(msg, ex);
                            this.stopAgent(msg);
                            this.stopChangeDetectorExtension();
                        }
                        this.createAgentBean(srvConn);
                        this.watchedAgentSvcName = agentRegSvc.getAgentServiceName(this.raveAgent.getName());
                        this.raveAgent.startAgentNameMappingNotification();
                        this.sendListernersNotifications(srvConn);
                        this.feedback.info("Server comm channel created!");
                    }
                    try {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("com.wily.rave.server.api.IWatchedAgent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        conn = (IWatchedAgent)MessageServiceFactory.getService((PostOffice)po, (Class)clazz, (String)this.watchedAgentSvcName);
                    }
                    catch (ServiceNotFoundException ex) {
                        throw new ConnectionException((Throwable)ex);
                    }
                    this.connectedProxies.add(new ProxyWrapper(conn));
                    return conn;
                }
                catch (ConnectionException ex) {
                    this.feedback.info("Caught ConnectionException while connecting, retrying... " + ex.getMessage());
                    pause = this.raveAgent.getRaveConfig().getWaitTimeBetweenConnectsInSec();
                    beanFetchAttempts = 0;
                }
                catch (ServiceException ex) {
                    this.feedback.error("Unexpected exception!", ex);
                    this.stopChangeDetectorExtension();
                }
            }
        }
    }

    private final void stopAgent(String msg) {
        this.raveAgent.shutDown();
        throw new StopCollectionException(msg);
    }

    private void pause(int timeInSec) {
        try {
            Thread.sleep(timeInSec * 1000);
        }
        catch (InterruptedException e) {
            this.feedback.warn("Unexpected InterruptedException, ignoring...", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final ConnectedServer getIsengardConnection() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    var2_3 = this;
                    synchronized (var2_3) {
                        copyConnUpCounter = this.connUpCounter;
                    }
                    srvConn = this.agent.IAgent_getIsengardServerConnection().getConnectedServer();
                    if (srvConn != null) {
                        return srvConn;
                    }
                    var3_4 = this;
                    synchronized (var3_4) {
                        if (copyConnUpCounter == this.connUpCounter) {
                            this.feedback.info("Waiting for communication to primary server to be reestablished...");
                            this.wait();
                            this.checkDestroyed();
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.feedback.warn("This thread should not be interrupted, ignoring...", e);
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
    }

    private void sendListernersNotifications(ConnectedServer srvConn) throws ConnectionException {
        Iterator iter = this.connectionListeners.iterator();
        while (iter.hasNext()) {
            ((IConnectionUpListener)iter.next()).connectionUp(srvConn);
        }
    }

    private void createAgentBean(ConnectedServer srvConn) throws ConnectionException, StopChangeDetectorExtensionException {
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.wily.rave.agent.RaveAgentBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            srvConn.addBean(clazz, (Object)new AgentBeanParamContainer(this.raveAgent, this.feedback));
        }
        catch (BeanActivationException e) {
            Throwable t = e.getCause();
            if (t instanceof ConnectionException) {
                throw (ConnectionException)t;
            }
            if (!(t instanceof EntryAlreadyExistsException)) {
                this.feedback.error("Unexpected exception activating ChangeDetector agent service.", e);
            }
            this.stopChangeDetectorExtension();
        }
    }

    public synchronized void connectionUp() {
        if (this.destroyed) {
            return;
        }
        this.connUpCounter = (this.connUpCounter + 1) % Integer.MAX_VALUE;
        this.notifyAll();
    }

    public synchronized void connectionDown() {
        this.watchedAgentSvcName = null;
        this.connectedProxies.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.notify();
        }
        this.agent.IAgent_getIsengardServerConnection().removeConnectionObserver((IServerConnectionNotification)this);
    }

    synchronized void addConnectionUpListener(IConnectionUpListener listener) {
        this.connectionListeners.add(listener);
    }

    synchronized void rmConnectionUpListener(IConnectionUpListener listener) {
        this.connectionListeners.remove(listener);
    }

    static void waitIsengardReady(IAgent coreAgent, IModuleFeedbackChannel feedback, int waitTimeInSec, int numAttempts) {
        if (coreAgent.IAgent_getIsengardServerConnection() != null) {
            return;
        }
        feedback.info("Isengard not available yet, waiting...");
        do {
            try {
                feedback.debug("Waiting for Isengard for " + waitTimeInSec + " seconds... (" + numAttempts + ")");
                Thread.sleep(waitTimeInSec * 1000);
            }
            catch (InterruptedException e) {
                feedback.warn("Unexpected InterruptedException, ignoring...", e);
                ++numAttempts;
            }
        } while (coreAgent.IAgent_getIsengardServerConnection() == null && --numAttempts > 0);
        if (coreAgent.IAgent_getIsengardServerConnection() == null) {
            String msg = "Isengard not available yet, giving up... ChangeDetector extension will not be started.";
            feedback.error(msg);
            throw new RuntimeException(msg);
        }
        feedback.info("Isengard enabled.");
    }

    private final void stopChangeDetectorExtension() throws StopChangeDetectorExtensionException {
        this.destroy();
        throw new StopChangeDetectorExtensionException();
    }

    private static final class ProxyWrapper {
        private final IWatchedAgent watchedAgent;

        private ProxyWrapper(IWatchedAgent watchedAgent) {
            this.watchedAgent = watchedAgent;
        }

        public boolean equals(Object other) {
            return other instanceof ProxyWrapper && ((ProxyWrapper)other).watchedAgent == this.watchedAgent;
        }

        public int hashCode() {
            return System.identityHashCode(this.watchedAgent);
        }
    }

    private static final class StopChangeDetectorExtensionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private StopChangeDetectorExtensionException() {
        }
    }
}

