/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.test.ctg;

import com.wily.powerpack.sysview.test.ctg.Test;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class TestJCA {
    private static int limit = 5;
    private static final String kConfigFileName = "testClasses.config";
    private String[] arguments;

    public TestJCA(String[] args) {
        this.arguments = args;
    }

    public static void main(String[] args) throws Exception {
        TestJCA test = new TestJCA(args);
        System.out.println("Beginning " + TestJCA.class.getCanonicalName());
        System.out.println("Beginning assembly and run of tests.");
        int result = test.assembleAndRunAllTests();
        System.out.println("Assembled and ran " + result + " tests.");
        System.out.println("Test runs complete!");
    }

    private int assembleAndRunAllTests() throws Exception {
        System.out.println("Assembling tests from testClasses.config");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(kConfigFileName)));
        int i = 0;
        while (reader.ready()) {
            String className = reader.readLine().trim();
            System.out.println("Assembling and running tests for class " + className);
            if (className.length() <= 0) continue;
            Class<?> theClass = Class.forName(className);
            if (theClass.getSuperclass().equals(Test.class)) {
                Method handleArgumentsMethod = theClass.getMethod("handleCommandLineArgs", String[].class);
                Method getDescriptionMethod = theClass.getMethod("getDescription", null);
                Object newInstance = theClass.newInstance();
                handleArgumentsMethod.invoke(newInstance, new Object[]{this.arguments});
                String description = (String)getDescriptionMethod.invoke(newInstance, null);
                System.out.println(description);
                Method doTestMethod = theClass.getMethod("doTest", null);
                int j = 0;
                while (j < limit) {
                    doTestMethod.invoke(newInstance, null);
                    ++j;
                }
                ++i;
                continue;
            }
            System.out.println("Class not an instance of Test: " + theClass.getCanonicalName());
        }
        return i;
    }
}

