/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.exception;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.ReentrancyHandler;
import com.wily.introscope.agent.exception.StackTracePrintStream;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class ExceptionProcessor {
    public static final boolean kExceptionThrow = true;
    public static final boolean kExceptionCatch = false;
    private static final ExceptionProcessor sExceptionProcessor;
    private static final StackTracePrintStream sStackTracePrintStream;
    private final Map fExceptionLoggedTable;
    private final ReentrancyHandler fExceptionReentrancyHandler = new ReentrancyHandler();
    private IStringEveryEventDataAccumulator fCatchCollector;
    private IStringEveryEventDataAccumulator fThrowCollector;

    static {
        sStackTracePrintStream = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        sExceptionProcessor = new ExceptionProcessor();
    }

    public static void traceThrownException(Throwable exception, String className, String methodName) {
        try {
            sExceptionProcessor.reentrancyManagingTraceException(exception, className, methodName, true);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while tracing a thrown exception", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public static void traceCaughtException(Throwable exception, String className, String methodName) {
        try {
            sExceptionProcessor.reentrancyManagingTraceException(exception, className, methodName, false);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while tracing a thrown exception", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    static AgentMetric debug_getThrowMetric() {
        Assertion.wilyAssert(false);
        IStringEveryEventDataAccumulator accumulator = sExceptionProcessor.getAccumulator(true);
        Assertion.wilyAssert(false);
        return accumulator.IDataAccumulator_getMetric();
    }

    static AgentMetric debug_getCatchMetric() {
        Assertion.wilyAssert(false);
        IStringEveryEventDataAccumulator accumulator = sExceptionProcessor.getAccumulator(false);
        Assertion.wilyAssert(false);
        return accumulator.IDataAccumulator_getMetric();
    }

    private ExceptionProcessor() {
        this.fExceptionLoggedTable = Collections.synchronizedMap(new WeakHashMap());
    }

    private synchronized void createThrowCollector() {
        if (this.fThrowCollector == null || this.fThrowCollector.isRemoved()) {
            try {
                DataAccumulatorFactory factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
                this.fThrowCollector = factory.safeGetThrownExceptionDataAccumulator("Exceptions:Thrown Exceptions Log");
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while creating the accumulator for thrown exceptions", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private synchronized void createCatchCollector() {
        if (this.fCatchCollector == null || this.fCatchCollector.isRemoved()) {
            try {
                DataAccumulatorFactory factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
                this.fCatchCollector = factory.safeGetCaughtExceptionDataAccumulator("Exceptions:Caught Exceptions Log");
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while creating the accumulator for caught exceptions", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private IStringEveryEventDataAccumulator getThrowCollector() {
        if (this.fThrowCollector == null || this.fThrowCollector.isRemoved()) {
            this.createThrowCollector();
        }
        return this.fThrowCollector;
    }

    private IStringEveryEventDataAccumulator getCatchCollector() {
        if (this.fCatchCollector == null || this.fCatchCollector.isRemoved()) {
            this.createCatchCollector();
        }
        return this.fCatchCollector;
    }

    private IStringEveryEventDataAccumulator getAccumulator(boolean throwOrCatch) {
        if (throwOrCatch) {
            return this.getThrowCollector();
        }
        return this.getCatchCollector();
    }

    private ReentrancyHandler getExceptionReentrancyHandler() {
        return this.fExceptionReentrancyHandler;
    }

    /*
     * Exception decompiling
     */
    public final void reentrancyManagingTraceException(Throwable theException, String className, String methodName, boolean throwOrCatch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 77->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isShutoff(boolean throwOrCatch) {
        return AgentShim.getAgentShim().IAgentShim_isMetricShutOff(this.getAccumulator(throwOrCatch).IDataAccumulator_getMetric());
    }

    private void traceException(Throwable theException, String className, String methodName, boolean throwOrCatch) {
        if (this.fExceptionLoggedTable.get(theException) != null) {
            return;
        }
        if (this.fExceptionLoggedTable.size() > 100) {
            this.fExceptionLoggedTable.clear();
        }
        this.fExceptionLoggedTable.put(theException, "");
        String stackTrace = this.getStackTrace(theException);
        IStringEveryEventDataAccumulator accumulator = this.getAccumulator(throwOrCatch);
        if (accumulator != null) {
            accumulator.IStringEveryEventDataAccumulator_addString(stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getStackTrace(Throwable e) {
        String result;
        StackTracePrintStream stackTracePrintStream = sStackTracePrintStream;
        synchronized (stackTracePrintStream) {
            sStackTracePrintStream.reset();
            e.printStackTrace(sStackTracePrintStream);
            result = sStackTracePrintStream.getString();
        }
        return result;
    }
}

