/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public class Logger {
    private static final Module module = new Module("EntryPointDetection");
    private static volatile IAgent agent = null;
    private static volatile Logger.LoggingHandler delegate;

    static {
        IAgent agent = Logger.getAgent();
        if (agent != null) {
            delegate = new Logger.LoggingHandler(module, agent);
        }
    }

    public static void logException(Exception e) {
        if (delegate != null) {
            delegate.logException(e);
        }
    }

    public static void logException(String message, Exception e) {
        if (delegate != null) {
            delegate.logException(message, e);
        }
    }

    public static void logWarningMessage(String message) {
        if (delegate != null) {
            delegate.logWarningMessage(message);
        }
    }

    public static void logInfoMessage(String message) {
        if (delegate != null) {
            delegate.logInfoMessage(message);
        }
    }

    public static void logDebugMessage(String message) {
        if (delegate != null) {
            delegate.logDebugMessage(message);
        }
    }

    public static void logDebugMessage(String message, Throwable e) {
        if (delegate != null) {
            delegate.logDebugMessage(message, e);
        }
    }

    public static void logTraceMessage(String message) {
        if (delegate != null) {
            delegate.logTraceMessage(message);
        }
    }

    public static void logMessage(String message, SeverityLevel level) {
        if (delegate != null) {
            delegate.logMessage(message, level);
        }
    }

    public static boolean isWarningEnabled() {
        return delegate != null && delegate.isWarningEnabled();
    }

    public static boolean isInfoEnabled() {
        return delegate != null && delegate.isInfoEnabled();
    }

    public static boolean isDebugEnabled() {
        return delegate != null && delegate.isDebugEnabled();
    }

    public static boolean isTraceEnabled() {
        return delegate != null && delegate.isTraceEnabled();
    }

    public static IAgent getAgent() {
        if (agent == null) {
            try {
                agent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException e) {
                AgentShim.handleError("Error while getting Agent instance for Intelligent Boundary Detection Logger", e);
            }
        }
        return agent;
    }

    public static Module getModule() {
        return module;
    }
}

