/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.AbstractTransactionElement;
import com.wily.introscope.agent.trace.cas.EndTransactionElement;
import com.wily.introscope.agent.trace.cas.IChildEditor;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IFaultSubscriber;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class APureMapTransactionElement
extends AbstractTransactionElement
implements ITransactionElement,
IEditableTransactionElement {
    private final ConcurrentHashMap fChildrenMap = new ConcurrentHashMap();

    public APureMapTransactionElement(ITransactionElement parent, boolean isStartTrace) {
        super(parent, isStartTrace);
    }

    @Override
    public Iterator iterateChildren() {
        return new PureMapIterator(this.fChildrenMap, this.fEndTransactionChild);
    }

    @Override
    public int countChildren() {
        int sizeOfEnd = this.fEndTransactionChild.get() == null ? 0 : 1;
        return this.fChildrenMap.size() + sizeOfEnd;
    }

    @Override
    public boolean isLastInTransaction() {
        return false;
    }

    @Override
    public ITransactionElement goToChildStartTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        ITransactionElement result = (ITransactionElement)this.fChildrenMap.get(key);
        if (result == null) {
            APureMapTransactionElement.checkCount(provider, key, tracerIndex, data, this);
            result = provider.getElementOnStartTrace(key, tracerIndex, data, this);
            ITransactionElement isPresent = this.fChildrenMap.putIfAbsent(key, result);
            if (isPresent != null) {
                return isPresent;
            }
            result.notifyPublished();
            return result;
        }
        return result;
    }

    @Override
    public ITransactionElement goToChild(Object key, ITransactionElementProvider provider) {
        return this.goToChildStartTransaction(key, 0, null, provider);
    }

    @Override
    public ITransactionElement goToChild(Object key, IStackElement data, ITransactionElementProvider provider) {
        return this.goToChildStartTransaction(key, 0, data, provider);
    }

    @Override
    public void terminateTransaction(String endKey) {
        if (!this.isEndTrace()) {
            this.setEndTrace(true);
            this.fChildrenMap.put(endKey, new EndTransactionElement(this));
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.fChildrenMap.isEmpty() || this.fEndTransactionChild.get() != null;
    }

    @Override
    public IErrorSubscriber getErrorSubscriber() {
        return null;
    }

    @Override
    public IStallSubscriber getStallSubscriber() {
        return null;
    }

    @Override
    public IFaultSubscriber getFaultSubscriber() {
        return null;
    }

    @Override
    public ITransactionElement getNextOnEndTransaction() {
        return this;
    }

    @Override
    public void offerChildrenForEdit(IChildEditor editor) {
        Iterator i = this.fChildrenMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry ee = i.next();
            ITransactionElement e = (ITransactionElement)ee.getValue();
            if (!editor.removeElement(e, ee.getKey())) continue;
            i.remove();
            editor.onPostRemove(e);
        }
    }

    @Override
    public void offerChildrenForRead(IChildRead reader) {
        ITransactionElement e2;
        for (ITransactionElement e2 : this.fChildrenMap.values()) {
            reader.readElement(e2);
        }
        e2 = (ITransactionElement)this.fEndTransactionChild.get();
        if (e2 != null) {
            reader.readElement(e2);
        }
    }

    @Override
    public void clearAllChildren() {
        this.clear();
        this.fEndTransactionChild.set(null);
    }

    private void clear() {
        this.fChildrenMap.clear();
    }

    public static class PureMapIterator
    implements Iterator {
        boolean hasStartedUsingSnapshotIterator = false;
        final AtomicReference fEnd;
        final Iterator snapshotIterator;

        PureMapIterator(ConcurrentHashMap map, AtomicReference end) {
            this.fEnd = end;
            this.snapshotIterator = map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.hasStartedUsingSnapshotIterator) {
                return this.snapshotIterator.hasNext();
            }
            return this.fEnd.get() != null || this.snapshotIterator.hasNext();
        }

        public Object next() {
            if (this.hasStartedUsingSnapshotIterator) {
                return this.snapshotIterator.next();
            }
            Object o = this.fEnd.get();
            if (o == null) {
                this.hasStartedUsingSnapshotIterator = true;
                return this.next();
            }
            this.hasStartedUsingSnapshotIterator = true;
            return o;
        }

        @Override
        public void remove() {
        }
    }
}

