/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SimpleModuleFeedbackChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class TracedSockets {
    private static final String kDelimiter = ":";
    private static final String kClampLevelPropertyKey = "com.wily.introscope.agent.sockets.clamp.level";
    private static final String kSocketClampMessage = "Socket clamping applied. Sockets crossed clamp level :";
    private static final int kDefaultClampLevelValue = 100;
    private static IModuleFeedbackChannel slog = TracedSockets.getModuleFeedbackChannel();
    private static int sClampLevel = TracedSockets.getSocketClampLevel();
    private static ConcurrentThreadLocalHashMap<Object, Object> sTracedSockets = TracedSockets.getCache("TracedSockets");
    private static volatile boolean sClampMsgLogged = false;
    private static final String kServerSocketAddress = "0.0.0.0";

    private static int getSocketClampLevel() {
        try {
            IAgent agent = AgentShim.getAgent();
            int value = agent.IAgent_getIndexedProperties().getIntProperty(kClampLevelPropertyKey, 100);
            if (value >= 0) {
                return value;
            }
            slog.warn("Invalid value was set for property com.wily.introscope.agent.sockets.clamp.level, agent will use the default value of 100");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        return 100;
    }

    private static final <K, V> ConcurrentThreadLocalHashMap<Object, Object> getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            return mapFactory.getConcurrentHashMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private static IModuleFeedbackChannel getModuleFeedbackChannel() {
        try {
            IAgent agent = AgentShim.getAgent();
            return agent.IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return new SimpleModuleFeedbackChannel("Socket Clamp");
        }
    }

    public static boolean add(InetSocketAddress endPoint) {
        if (endPoint == null) {
            return false;
        }
        return TracedSockets.add(endPoint.getAddress().getHostAddress(), endPoint.getPort());
    }

    public static boolean add(int port) {
        return TracedSockets.add(kServerSocketAddress, port);
    }

    public static boolean add(String ipAddress, int port) {
        if (ipAddress == null) {
            return false;
        }
        String key = TracedSockets.generateKey(ipAddress, port);
        int count = sTracedSockets.size();
        if (count > sClampLevel) {
            if (!sClampMsgLogged) {
                slog.warn(kSocketClampMessage + count);
                sClampMsgLogged = true;
                if (slog.isTraceEnabled()) {
                    slog.trace("Traced Sockets: " + TracedSockets.getTracedSockets());
                }
            }
            return false;
        }
        sTracedSockets.putIfAbsent(key, true);
        return true;
    }

    private static String getTracedSockets() {
        StringBuffer buffer = new StringBuffer();
        for (Object key : sTracedSockets.keySet()) {
            buffer.append(key);
            buffer.append(" , ");
        }
        return buffer.toString();
    }

    public static boolean isTraced(int port) {
        return TracedSockets.isTraced(kServerSocketAddress, port);
    }

    public static boolean isTraced(InetSocketAddress address) {
        if (address == null) {
            return false;
        }
        InetAddress addr = address.getAddress();
        return TracedSockets.isTraced(addr, address.getPort());
    }

    public static boolean isTraced(InetAddress addr, int port) {
        if (addr == null) {
            return false;
        }
        return TracedSockets.isTraced(addr.getHostAddress(), port);
    }

    public static boolean isTraced(Socket socket) {
        if (socket == null) {
            return false;
        }
        InetAddress addr = socket.getInetAddress();
        return TracedSockets.isTraced(addr, socket.getPort());
    }

    public static boolean isTraced(String ipAddress, int port) {
        String key = TracedSockets.generateKey(ipAddress, port);
        return sTracedSockets.containsKey(key);
    }

    public static void clearTracedSocketList() {
    }

    protected static String generateKey(String ipAddress, int port) {
        return String.valueOf(port) + kDelimiter + ipAddress.trim();
    }
}

