/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.DuplicateHandlingBlameStack;
import com.wily.introscope.agent.blame.IAllocatorChangeListener;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBlameStackAllocator;
import com.wily.introscope.agent.blame.NullBlameStack;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

public class ExtensionsBlameStackAllocator
implements IBlameStackAllocator {
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ITransactionTraceListener fListener;
    private IAllocatorChangeListener fChangeListener;
    private Class fRegisteredExtensionBlameStack;
    private int fTraceClamp;
    private long fCacheFlushFrequency;
    private boolean fTraceEnabled;
    private IAgent fAgent;
    private IConfigurationListener fConfigListener;
    public static final String kBundledTraceEnablingProperty = "com.wily.introscope.agent.transactiontrace.boundaryTracing.enable";
    public static final String kBundledTraceClampProperty = "com.wily.introscope.agent.transactiontrace.boundaryTracing.clamp";
    public static final String kBundledTraceCacheFlushFrequency = "com.wily.introscope.agent.transactiontrace.boundaryTracing.cacheFlushFrequency";
    public static final int kBundledTraceSizeDefaultValue = 1000;
    public static final int kBundledTraceClampDefaultValue = 10000;
    public static final long kBundledTraceCacheFlushDefaultValue = 30L;
    private static final long kNumberOfMillisecsInOneDay = 86400000L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ExtensionsBlameStackAllocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, IAgent agent) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fListener = listener;
        this.fChangeListener = null;
        this.fAgent = agent;
    }

    private void checkAndUpdate(IndexedProperties props) {
        int traceClamp = props.getIntProperty(kBundledTraceClampProperty, 10000);
        boolean traceEnabled = props.getBooleanProperty(kBundledTraceEnablingProperty, true);
        long cacheFlushFrequency = props.getLongProperty(kBundledTraceCacheFlushFrequency, 30L) * 86400000L;
        if (traceClamp != this.fTraceClamp || traceEnabled != this.fTraceEnabled || this.fCacheFlushFrequency != cacheFlushFrequency) {
            this.fTraceClamp = traceClamp;
            this.fTraceEnabled = traceEnabled;
            this.fCacheFlushFrequency = cacheFlushFrequency;
            this.fFeedback.info("DependencyMap properties were changed and reconfigured");
        }
    }

    public boolean isTraceExtensionEnabled() {
        return this.fTraceEnabled;
    }

    public void registerExtensionBlameStack(Class extensionStack) {
        this.fTraceClamp = this.fAgent.IAgent_getIndexedProperties().getIntProperty(kBundledTraceClampProperty, 10000);
        this.fTraceEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kBundledTraceEnablingProperty, true);
        this.fCacheFlushFrequency = this.fAgent.IAgent_getIndexedProperties().getLongProperty(kBundledTraceCacheFlushFrequency, 30L) * 86400000L;
        this.fConfigListener = new ExtensionStackConfigurationListener(this);
        this.fAgent.addConfigurationListener(this.fConfigListener);
        this.fRegisteredExtensionBlameStack = extensionStack;
    }

    public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
        if (this.fTraceEnabled) {
            try {
                Class[] classArray = new Class[5];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.wily.util.feedback.IModuleFeedbackChannel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("com.wily.util.text.IStringLocalizer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("com.wily.introscope.agent.transactiontrace.ITransactionTraceListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[3] = clazz4;
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[4] = clazz5;
                Constructor c = this.fRegisteredExtensionBlameStack.getConstructor(classArray);
                return new DuplicateHandlingBlameStack((IBlameStack)c.newInstance(this.fFeedback, this.fLocalizer, this.fListener, new Integer(this.fTraceClamp), new Long(this.fCacheFlushFrequency)));
            }
            catch (Exception e) {
                this.fAgent.IAgent_getModuleFeedback().error("ExtensionsBlameStackAllocator: allocate blame stack failed with " + e.getMessage());
                this.fAgent.IAgent_getModuleFeedback().debug(e);
            }
        } else if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().debug("ExtensionsBlameStackAllocator: allocating a NullBlameStack since BundleTrace was disabled");
        }
        return new NullBlameStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
        ExtensionsBlameStackAllocator extensionsBlameStackAllocator = this;
        synchronized (extensionsBlameStackAllocator) {
            if (this.fChangeListener != null) {
                Assertion.wilyFail("Error: only one listener currently supported");
            }
            this.fChangeListener = listener;
        }
    }

    private static class ExtensionStackConfigurationListener
    implements IConfigurationListener {
        ExtensionsBlameStackAllocator parent;

        public ExtensionStackConfigurationListener(ExtensionsBlameStackAllocator parent) {
            this.parent = parent;
        }

        public void onChange(IndexedProperties props) {
            this.parent.checkAndUpdate(props);
        }
    }
}

