/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StatusErrorLogger {
    private String fLogPath;
    private List<String> fInfoList;
    private List<String> fErrorList;

    public StatusErrorLogger(String logPath) throws IOException {
        this.fLogPath = logPath;
        File logFile = new File(this.fLogPath);
        if (!logFile.exists() && !logFile.createNewFile()) {
            throw new IOException("Failed to create status error log file");
        }
        this.fInfoList = new ArrayList<String>();
        this.fErrorList = new ArrayList<String>();
    }

    public void info(String msg) {
        this.fInfoList.add(msg);
    }

    public void error(String msg) {
        this.fErrorList.add(msg);
    }

    public void save() {
        block26: {
            StringBuilder strBldr = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            if (this.fInfoList.size() > 0) {
                strBldr.append("<infos>").append(newLine);
            }
            for (String log : this.fInfoList) {
                strBldr.append("\t<info>").append(log).append("</info>").append(newLine);
            }
            if (this.fInfoList.size() > 0) {
                strBldr.append("</infos>");
            }
            if (this.fErrorList.size() > 0) {
                strBldr.append("<errors>").append(newLine);
            }
            for (String log : this.fErrorList) {
                strBldr.append("\t<error>").append(log).append("</error>").append(newLine);
            }
            if (this.fErrorList.size() > 0) {
                strBldr.append("</errors>");
            }
            FileWriter writer = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    writer = new FileWriter(this.fLogPath);
                    bufferedWriter = new BufferedWriter(writer);
                    bufferedWriter.write(strBldr.toString());
                    bufferedWriter.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    this.fInfoList.clear();
                    this.fErrorList.clear();
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.fInfoList.clear();
                this.fErrorList.clear();
                throw throwable;
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.fInfoList.clear();
            this.fErrorList.clear();
        }
    }
}

