/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteClassUtil {
    public static final int CLASS_MAGIC = -889275714;
    private static char kDotSeparator = (char)46;
    private static char kJarSeparator = (char)47;
    private static String kClassExtension = ".class";

    public static byte[] getBytesForClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + cls.getName());
        InputStream is = null;
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader == null) {
            return ByteClassUtil.getBytesForClassUsingClass(cls, limit, feedback);
        }
        String path = String.valueOf(cls.getName().replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = classLoader.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static byte[] getBytesForClass(ClassLoader classLoader, String className, int limit, IModuleFeedbackChannel feedback) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + className);
        InputStream is = null;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String path = String.valueOf(className.replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = classLoader.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static byte[] getBytesForClassUsingClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + cls.getName());
        InputStream is = null;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        String path = String.valueOf(cls.getName().replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = cl.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getBytesForClass(InputStream is, int classFileSizeLimit, IModuleFeedbackChannel feedback) throws IOException {
        ByteArrayOutputStream baos;
        block10: {
            block9: {
                baos = null;
                try {
                    baos = new ByteArrayOutputStream();
                    byte[] byteArray = new byte[2048];
                    int counter = 0;
                    int i = is.read(byteArray);
                    while (i > 0) {
                        if (counter > classFileSizeLimit) {
                            feedback.debug("Cannot read Class File bigger than configured size - " + classFileSizeLimit / 512 + "MB");
                            Object var7_7 = null;
                            break block9;
                        }
                        baos.write(byteArray, 0, i);
                        ++counter;
                        i = is.read(byteArray);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            is.close();
            return null;
        }
        Object var7_9 = null;
        try {}
        catch (Exception exception) {}
        is.close();
        byte[] retArray = baos.toByteArray();
        feedback.trace("returning byte array of length ->" + retArray.length);
        return retArray;
    }
}

