/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.stream;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Semaphore;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.stream.MessageStreamPublisher;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import java.util.HashMap;
import java.util.Map;

public class RegisteredMessageStreamPublisher
extends MessageStreamPublisher {
    private final String fServiceName;
    private volatile boolean fSubscriptionsComplete;
    private Semaphore fWaitForSubscriptions = new Semaphore(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredMessageStreamPublisher(PostOffice po, String streamName, Class interfaceName, Map properties, String[] securityGroup) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        super(po, interfaceName);
        RegisteredMessageStreamPublisher registeredMessageStreamPublisher = this;
        synchronized (registeredMessageStreamPublisher) {
            this.fServiceName = streamName.charAt(0) == '/' ? "/stream" + streamName : "/stream/" + streamName;
            this.fSubscriptionsComplete = false;
        }
        if (securityGroup == null) {
            this.allowAllGroupsToAccess();
        } else {
            this.setGroupAccess(securityGroup);
        }
        this.registerStream(properties);
        this.waitForSubscriptions();
    }

    public RegisteredMessageStreamPublisher(PostOffice po, String serviceName, Class interfaceName, String[] securityGroup) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        this(po, serviceName, interfaceName, new HashMap(), securityGroup);
    }

    public void close() {
        this.unregisterStream();
        super.close();
    }

    private void registerStream(Map properties) throws EntryAlreadyExistsException, ConnectionException {
        IRegistryService client = this.getPostOffice().getRegistry();
        RegistryEntry entry = new RegistryEntry();
        entry.setAddress(this.getAddress());
        entry.setProperties(properties);
        client.addEntry(this.getPostOffice().getSpecifier(), new DirectoryPath(this.fServiceName), entry);
    }

    private void unregisterStream() {
        try {
            IRegistryService client = this.getPostOffice().getRegistry();
            client.deleteEntry(new DirectoryPath(this.fServiceName));
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (ConnectionException connectionException) {}
    }

    protected void subscriptionsFinished() {
    }

    private final void waitForSubscriptions() {
        while (!this.fSubscriptionsComplete) {
            try {
                this.fWaitForSubscriptions.acquire();
            }
            catch (InterruptedException e) {
                throw new UnexpectedExceptionError(e);
            }
        }
    }

    public synchronized void SubscriptionsFinished() {
        this.fSubscriptionsComplete = true;
        this.subscriptionsFinished();
        this.fWaitForSubscriptions.release();
    }
}

