/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.dumpproperties;

import com.wily.introscope.ext.dumpproperties.Feedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class Service {
    protected IModuleFeedbackChannel log;
    private static final Comparator safeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                try {
                    Comparable c1 = (Comparable)o1;
                    Comparable c2 = (Comparable)o2;
                    return c1.compareTo(c2);
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            return 0;
        }
    };

    protected void dumpFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        Feedback feedback = new Feedback(this.log, file.getName());
        feedback.info("Dumping file " + file.getAbsolutePath());
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().startsWith("#")) continue;
                feedback.info(line);
            }
        }
        catch (Exception e) {
            feedback.error("Error dumping file " + file.getAbsolutePath(), e);
        }
    }

    protected void dumpProperties(Map properties) {
        Feedback feedback = new Feedback(this.log, "Properties");
        ArrayList keys = new ArrayList(properties.keySet());
        Collections.sort(keys, safeComparator);
        try {
            for (Object key : keys) {
                feedback.info(String.valueOf(this.getString(key)) + "=" + this.getString(properties.get(key)));
            }
        }
        catch (Exception e) {
            feedback.error("Unable to dump properties", e);
        }
    }

    protected String getString(Object key) {
        if (key == null) {
            return "null";
        }
        try {
            return key.toString();
        }
        catch (Exception e) {
            return "{ error occured: " + e.toString() + " }";
        }
    }
}

