/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.DGExactClassMatcher;
import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.IExportDirectiveCallback;
import com.wily.diagnos.cmp.directives.IExportableDirective;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.tracer.builder.DynamicMethodTracerBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;

public final class TraceOneMethodExactClassLabeledDirective
extends ADirective
implements IExportableDirective {
    private final IClassName fClassName;
    private final IMethodName fMethodName;
    private final TracerName fTracerName;
    private final FlagName fTracerFlag;
    private final String fNameParameter;
    private final String fLabel;

    public TraceOneMethodExactClassLabeledDirective(String source, int lineNumber, IClassName className, IMethodName methodName, TracerName tracerName, String nameParameter, String label, FlagName tracerGroup) {
        super(source, lineNumber);
        this.fClassName = className;
        this.fMethodName = methodName;
        this.fTracerName = tracerName;
        this.fNameParameter = nameParameter;
        this.fLabel = label;
        this.fTracerFlag = tracerGroup;
    }

    private IClassName getClassName() {
        return this.fClassName;
    }

    private IMethodName getMethodName() {
        return this.fMethodName;
    }

    private TracerName getTracerName() {
        return this.fTracerName;
    }

    private String getNameParameter() {
        return this.fNameParameter;
    }

    private String getLabel() {
        return this.fLabel;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = null;
        if (this.fTracerFlag != null) {
            flag = builder.getTracerGroupBuilder(this.fTracerFlag);
            flag.setDeclared(true);
            flag.setEnabled(true);
        }
        builder.addTracer(new DynamicMethodTracerBuilder(this.IDirective_getSource(), this.IDirective_getLineNumber(), new DGExactClassMatcher(this.getClassName()), new NamedMethodMatcher(this.getMethodName()), this.getTracerName(), this.getNameParameter(), flag, this.getLabel(), false, true, this.fClassName));
    }

    public void IExportableDirective_export(IExportDirectiveCallback callback) {
        callback.export(this.getSource(), this.fTracerFlag, this.getClassName(), this.getMethodName(), this.getTracerName(), this.getNameParameter(), this.getLabel(), true, null, null);
    }
}

