/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.IMacAddressResolver;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptor;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptorComparator;
import com.wily.introscope.agent.environment.NetworkInterfaceSpecifier;
import com.wily.introscope.agent.environment.SubNetworks;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class NetworkInterfaceDescriptorFactory {
    private final Module module;
    private final IModuleFeedbackChannel feedback;
    private final IStringLocalizer localizer;
    private final InetAddress[] defaultIPAddresses;
    private final IMacAddressResolver macAddressResolver;
    private final SubNetworks subNetworks;
    private static final String macAddressResolverClassName = "com.wily.introscope.agent.environment.Java16MacAddressResolver";

    public NetworkInterfaceDescriptorFactory(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer, InputStream subNetworksStream) {
        IMacAddressResolver r;
        block8: {
            this.module = module;
            this.feedback = feedback;
            this.localizer = localizer;
            InetAddress[] localIPAddresses = null;
            try {
                localIPAddresses = new InetAddress[]{InetAddress.getLocalHost()};
            }
            catch (UnknownHostException unknownHostException) {}
            this.defaultIPAddresses = localIPAddresses;
            this.subNetworks = subNetworksStream == null ? new SubNetworks() : new SubNetworks(this.module, this.feedback, this.localizer, subNetworksStream);
            r = null;
            try {
                r = (IMacAddressResolver)Class.forName(macAddressResolverClassName).newInstance();
                if (feedback.isDebugEnabled(module)) {
                    feedback.debug(module, "EnvironmentAdministrator loading MAC address resolver " + (r == null ? "null" : r.getClass().getName()));
                }
            }
            catch (Exception exception) {
                if (feedback.isDebugEnabled(module)) {
                    feedback.debug(module, "Failed to load com.wily.introscope.agent.environment.Java16MacAddressResolver");
                }
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            }
            catch (LinkageError e) {
                if (!feedback.isDebugEnabled(module)) break block8;
                feedback.debug(module, "Failed to load com.wily.introscope.agent.environment.Java16MacAddressResolver" + e.getMessage());
            }
        }
        this.macAddressResolver = r;
    }

    public NetworkInterfaceDescriptor findNetworkInterface(NetworkInterfaceSpecifier requiredInterface) {
        NetworkInterface ni;
        NetworkInterface networkInterface = ni = requiredInterface == null ? null : this.getNetworkInterfaceByName(requiredInterface.getName());
        if (ni != null) {
            Enumeration inetAddresses = this.getIPAddressEnumeration(ni);
            int index = 0;
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = (InetAddress)inetAddresses.nextElement();
                if (requiredInterface.getIndex() == index) {
                    try {
                        return new NetworkInterfaceDescriptor(ni, inetAddress, this.defaultIPAddresses, index, this.macAddressResolver, this.subNetworks);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!this.feedback.isDebugEnabled(this.module)) break;
                        this.feedback.debug(this.module, "Selected interface is not an bound to an IP address");
                        break;
                    }
                }
                ++index;
            }
        }
        return null;
    }

    private NetworkInterface getNetworkInterfaceByName(String name) {
        if (name == null) {
            return null;
        }
        try {
            return NetworkInterface.getByName(name);
        }
        catch (SocketException e) {
            this.feedback.warn(this.module, "Failed to get network interfaces: " + e, e);
            return null;
        }
    }

    public NetworkInterfaceDescriptor[] getAllNetworkInterfaces(int ipFamilyOrder) {
        Enumeration netInterfaces = this.getNetworkInterfacesEnumeration();
        ArrayList<NetworkInterfaceDescriptor> weightedInterfaces = new ArrayList<NetworkInterfaceDescriptor>();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = (NetworkInterface)netInterfaces.nextElement();
            if (ni == null) continue;
            Enumeration inetAddresses = this.getIPAddressEnumeration(ni);
            int index = 0;
            while (inetAddresses.hasMoreElements()) {
                try {
                    NetworkInterfaceDescriptor nid = new NetworkInterfaceDescriptor(ni, (InetAddress)inetAddresses.nextElement(), this.defaultIPAddresses, index, this.macAddressResolver, this.subNetworks);
                    weightedInterfaces.add(nid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++index;
            }
        }
        if (weightedInterfaces.size() > 0) {
            NetworkInterfaceDescriptor[] sortedNetworkInterfaces = weightedInterfaces.toArray(new NetworkInterfaceDescriptor[0]);
            Arrays.sort(sortedNetworkInterfaces, new NetworkInterfaceDescriptorComparator(ipFamilyOrder));
            if (this.feedback.isDebugEnabled(this.module)) {
                int i = 0;
                while (i < sortedNetworkInterfaces.length) {
                    this.feedback.debug(this.module, "Network Interface " + sortedNetworkInterfaces[i]);
                    ++i;
                }
            }
            return sortedNetworkInterfaces;
        }
        return null;
    }

    public InetAddress[] getDefaultIPAddresses() {
        return this.defaultIPAddresses;
    }

    private Enumeration getNetworkInterfacesEnumeration() {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.feedback.warn(this.module, "Failed to get network interfaces: " + e, e);
            return new EmptyEnumeration();
        }
    }

    private Enumeration getIPAddressEnumeration(NetworkInterface ni) {
        return ni.getInetAddresses();
    }

    private static class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

