/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiAgentPlugin;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.DynamicClassLookup;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.trace.ITraceSupportFactory;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.extension.IPluginLoaderCallback;
import com.wily.introscope.extension.PluginLoader;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

public final class TraceSupportFactoryLoader
extends DynamicClassLookup {
    private static final String kTracerPluginType = "tracesupport";
    private static final int kCurrentTracerSupportPluginVersion = 1;
    private static final Class[] kTracerSupportFactoryConstructorParameterTypes;
    private IValidationFeedbackChannel fValidationFeedbackChannel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.IAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        kTracerSupportFactoryConstructorParameterTypes = classArray;
    }

    public TraceSupportFactoryLoader(IAgent agent) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.wily.introscope.agent.trace.ITraceSupportFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(agent, clazz, kTracerSupportFactoryConstructorParameterTypes);
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
        this.loadTracerPlugins();
    }

    public final ITraceSupportFactory createTracerSupportFactory(String factoryClassName, String parameters) throws Exception {
        AttributeListing factoryParameters = new AttributeListing();
        factoryParameters.load(parameters);
        DynamicClassLookup.DynamicClassEntry entry = this.loadDynamicClassEntry(factoryClassName);
        Class factoryClass = entry.getDynamicClass();
        IAgent factoryAgent = entry.getDynamicAgent();
        if (!this.getExpectedType().isAssignableFrom(factoryClass)) {
            throw new InvalidDynamicClassException("Class is not assignable to the expected type", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Wrong_Type_Error", factoryClassName));
        }
        Constructor constructor = factoryClass.getConstructor(kTracerSupportFactoryConstructorParameterTypes);
        ITraceSupportFactory factory = (ITraceSupportFactory)constructor.newInstance(factoryAgent);
        Assertion.wilyAssert(false);
        return factory;
    }

    public final ITraceSupportFactory createTracerSupportFactoryOSGi(final IAgent agent, String factoryClassName, String parameters) throws Exception {
        final ITraceSupportFactory[] result = new ITraceSupportFactory[1];
        PluginLoader.loadPlugins("com.wily.introscope.agent.tracesupport", new IPluginLoaderCallback(){

            public void onExtensionFound(Object configurationElement, Object extension) {
                if (result[0] == null && extension != null && extension instanceof ITraceSupportFactory) {
                    result[0] = (ITraceSupportFactory)extension;
                    try {
                        ((IOSGiAgentPlugin)((Object)result[0])).getInstance(agent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return result[0];
    }

    private void loadTracerPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kTracerPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadTracerPlugin(plugins[i]);
            ++i;
        }
    }

    private void loadTracerPlugin(IPlugin plugin) {
        Class tracerFactoryClass;
        IModuleFeedbackChannel iModuleFeedbackChannel = this.getModuleFeedback();
        IStringLocalizer iStringLocalizer = this.getStringLocalizer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.wily.introscope.agent.trace.ITraceSupportFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((tracerFactoryClass = ExtensionUtilities.loadEntryPointClass(iModuleFeedbackChannel, iStringLocalizer, plugin, 1, clazz, this.fValidationFeedbackChannel)) != null) {
            IStringLocalizer tracerFactoryLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(tracerFactoryClass.getName(), tracerFactoryClass, tracerFactoryLocalizer);
                this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            }
            catch (DuplicateDynamicClassException ddce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Duplicate_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, ddce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, idce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(idce);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, t);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(t);
            }
        }
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }
}

