/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.DynamicClassLookup;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.TracerFactoryOSGiLoader;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

final class TracerFactoryLoader
extends DynamicClassLookup {
    private static final String kTracerPluginType = "tracer";
    private static final int kCurrentTracerPluginVersion = 1;
    private static final Class[] kTracerFactoryConstructorParameterTypes;
    private IValidationFeedbackChannel fValidationFeedbackChannel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.IAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.wily.util.properties.AttributeListing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.wily.introscope.agent.trace.ProbeIdentification");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        kTracerFactoryConstructorParameterTypes = classArray;
    }

    public TracerFactoryLoader(IAgent agent) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("com.wily.introscope.agent.trace.ITracerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(agent, clazz, kTracerFactoryConstructorParameterTypes);
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
        this.loadTracerPlugins();
    }

    public final ITracerFactory createTracerFactory(String factoryClassName, String parameters, ProbeIdentification identification, Object tracedObject) throws Exception {
        AttributeListing factoryParameters = new AttributeListing();
        factoryParameters.load(parameters);
        DynamicClassLookup.DynamicClassEntry entry = this.loadDynamicClassEntry(factoryClassName);
        Class factoryClass = entry.getDynamicClass();
        IAgent factoryAgent = entry.getDynamicAgent();
        if (!this.getExpectedType().isAssignableFrom(factoryClass)) {
            throw new InvalidDynamicClassException("Class is not assignable to the expected type", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Wrong_Type_Error", factoryClassName));
        }
        Constructor constructor = factoryClass.getConstructor(kTracerFactoryConstructorParameterTypes);
        ITracerFactory factory = (ITracerFactory)constructor.newInstance(factoryAgent, factoryParameters, identification, tracedObject);
        Assertion.wilyAssert(false);
        return factory;
    }

    private void loadTracerPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kTracerPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadTracerPlugin(plugins[i]);
            ++i;
        }
    }

    private void loadTracerPlugin(IPlugin plugin) {
        Class tracerFactoryClass;
        IModuleFeedbackChannel iModuleFeedbackChannel = this.getModuleFeedback();
        IStringLocalizer iStringLocalizer = this.getStringLocalizer();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("com.wily.introscope.agent.trace.ITracerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((tracerFactoryClass = ExtensionUtilities.loadEntryPointClass(iModuleFeedbackChannel, iStringLocalizer, plugin, 1, clazz, this.fValidationFeedbackChannel)) != null) {
            IStringLocalizer tracerFactoryLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(tracerFactoryClass.getName(), tracerFactoryClass, tracerFactoryLocalizer);
                this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            }
            catch (DuplicateDynamicClassException ddce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Duplicate_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, ddce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, idce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(idce);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, t);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(t);
            }
        }
    }

    public void addAllExtensions(TracerFactoryOSGiLoader tracerFactoryOSGiLoader) {
        super.addAllExtensions(tracerFactoryOSGiLoader);
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }
}

