/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.jdbc;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICachedNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.StringUtils;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import java.util.Hashtable;

public final class DriverNameFormatter
implements ICachedNameFormatter {
    public static final String kDriverNamePlaceHolder = "{drivername}";
    private static final String kGetConnectionMethodName = "getConnection";
    private static final DriverNameFormatterLock sLock = new DriverNameFormatterLock();
    private static final Hashtable sDriverLookup = new Hashtable();
    private static ThreadLocal reentrancyMonitor = new ThreadLocal(){

        protected Object initialValue() {
            return new int[1];
        }
    };
    private final IAgent fAgent;

    private static DriverNameFormatterLock getDriverNameFormatterLock() {
        return sLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDriverName(IAgent agent, Object sampleTracedObject) {
        String result = "Unknown Driver";
        int[] reentrancyCounter = (int[])reentrancyMonitor.get();
        try {
            if (reentrancyCounter[0] == 0) {
                reentrancyCounter[0] = 1;
                if (sampleTracedObject == null) {
                    agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] Driver name requested for null object");
                } else {
                    String name;
                    Class<?> cls = sampleTracedObject.getClass();
                    result = name = cls.getName();
                    String driverName = (String)sDriverLookup.get(name);
                    if (driverName != null) {
                        result = driverName;
                    } else {
                        DriverNameFormatterLock driverNameFormatterLock = DriverNameFormatter.getDriverNameFormatterLock();
                        synchronized (driverNameFormatterLock) {
                            block21: {
                                driverName = (String)sDriverLookup.get(name);
                                if (driverName == null) {
                                    try {
                                        if (sampleTracedObject instanceof Statement) {
                                            Method method = cls.getMethod(kGetConnectionMethodName, new Class[0]);
                                            if (method != null) {
                                                int modifiers = method.getModifiers();
                                                if (!Modifier.isAbstract(modifiers)) {
                                                    Connection connection = (Connection)method.invoke(sampleTracedObject, new Object[0]);
                                                    if (connection != null) {
                                                        DatabaseMetaData metadata = connection.getMetaData();
                                                        if (metadata != null) {
                                                            driverName = metadata.getDriverName();
                                                            if (driverName != null && !driverName.equalsIgnoreCase("")) {
                                                                result = driverName;
                                                            }
                                                            break block21;
                                                        }
                                                        agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] Connection returned null metadata");
                                                        break block21;
                                                    }
                                                    agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] " + kGetConnectionMethodName + " method returned a null connection");
                                                    break block21;
                                                }
                                                agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] " + kGetConnectionMethodName + " method is abstract");
                                                break block21;
                                            }
                                            agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] Object does not have a " + kGetConnectionMethodName + " method");
                                            break block21;
                                        }
                                        agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] Object is not a Statement");
                                    }
                                    catch (ThreadDeath td) {
                                        throw td;
                                    }
                                    catch (Throwable t) {
                                        agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] Caught an exception", t);
                                    }
                                }
                            }
                        }
                    }
                    agent.IAgent_getModuleFeedback().debug("[DriverNameFormatter] [" + name + "] Setting driver name to '" + result + "'");
                    sDriverLookup.put(name, result);
                }
            }
            Object var12_16 = null;
            reentrancyCounter[0] = 0;
            return result;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            reentrancyCounter[0] = 0;
            throw throwable;
        }
    }

    public DriverNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public final String INameFormatter_format(String name, InvocationData data) {
        return this.ICachedNameFormatter_format(name, data.getProbeInformation().getProbeIdentification(), data.getInvocationObject());
    }

    public final String ICachedNameFormatter_format(String name, ProbeIdentification probe, Object sampleTracedObject) {
        Assertion.wilyAssert(false);
        if (name.indexOf(kDriverNamePlaceHolder, 0) >= 0) {
            String driverName = DriverNameFormatter.getDriverName(this.fAgent, sampleTracedObject);
            name = StringUtils.replace(name, kDriverNamePlaceHolder, driverName);
        }
        return name;
    }

    static void debug_addDriverLookup(String runtimeClassName, String driverName) {
        sDriverLookup.put(runtimeClassName, driverName);
    }

    static void debug_clearDriverLookup() {
        sDriverLookup.clear();
    }

    private static class DriverNameFormatterLock {
        private DriverNameFormatterLock() {
        }
    }
}

