/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.DuplicateHandlingBlameStack;
import com.wily.introscope.agent.blame.IAllocatorChangeListener;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBlameStackAllocator;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.agent.transactiontrace.TransactionRecordingBlameStack;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

public class TransactionRecordingBlameStackAllocator
implements IBlameStackAllocator {
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ITransactionTraceListener fListener;
    private ITransactionTraceFilter[] fFilters;
    private IAllocatorChangeListener fChangeListener;
    private volatile int fComponentCountClamp;
    private volatile int fHeadFilterClamp;
    private final ITransactionEnvironment fTransactionEnv;
    private IAgent fAgent;
    static /* synthetic */ Class class$0;

    public TransactionRecordingBlameStackAllocator(IAgent agent, ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, ITransactionTraceFilter[] filters, ITransactionEnvironment transactionEnv) {
        this.fAgent = agent;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fListener = listener;
        this.fFilters = filters;
        this.fChangeListener = null;
        this.defineConfigurationProperties(configManager, module, feedback, localizer);
        this.fTransactionEnv = transactionEnv;
    }

    public void setFilters(ITransactionTraceFilter[] filters) {
        this.fFilters = filters;
        this.notifyListener();
    }

    private void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.ACommonAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(this.fAgent.getClass()) && ((Boolean)((ACommonAgent)this.fAgent).fAgentBlameConfigurationOldProperty.getValue()).booleanValue()) {
            configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.componentCountClamp", new Integer(5000), "TT_Component_Count_Limit", feedback, module, localizer){

                public void set(Object value) {
                    TransactionRecordingBlameStackAllocator.this.fComponentCountClamp = (Integer)value;
                    TransactionRecordingBlameStackAllocator.this.notifyListener();
                }
            });
            configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontrace.headFilterClamp", new Integer(30), "TT_Head_Filter_Limit", feedback, module, localizer){

                public void set(Object value) {
                    TransactionRecordingBlameStackAllocator.this.fHeadFilterClamp = (Integer)value;
                    TransactionRecordingBlameStackAllocator.this.notifyListener();
                }
            });
        }
    }

    public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
        return new DuplicateHandlingBlameStack(new TransactionRecordingBlameStack(this.fFeedback, this.fLocalizer, this.fListener, this.fFilters, this.fComponentCountClamp, this.fHeadFilterClamp, this.fTransactionEnv));
    }

    ITransactionTraceFilter[] debug_getFilters() {
        return this.fFilters;
    }

    private synchronized void notifyListener() {
        if (this.fChangeListener != null) {
            this.fChangeListener.allocatorChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
        TransactionRecordingBlameStackAllocator transactionRecordingBlameStackAllocator = this;
        synchronized (transactionRecordingBlameStackAllocator) {
            if (this.fChangeListener != null) {
                Assertion.wilyFail("Error: only one listener currently supported");
            }
            this.fChangeListener = listener;
        }
    }
}

