/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.util.clock.MasterClock;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class GUIDGenerator {
    private static Map instances = new HashMap();
    private Random seeder;
    private String hostAndSystemID;
    static final char[] kcharsHexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String kstDefaultHost = "00000000";
    public static final String kDefaultSeeder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.security.SecureRandom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        kDefaultSeeder = clazz.getName();
    }

    private GUIDGenerator() {
        this(new SecureRandom());
    }

    private GUIDGenerator(Random aSeeder) {
        byte[] addr;
        this.seeder = aSeeder;
        this.seeder.nextInt();
        StringBuffer buffer = new StringBuffer(16);
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            addr = kstDefaultHost.getBytes();
        }
        buffer.append(GUIDGenerator.toHex(GUIDGenerator.toInt(addr), 8));
        buffer.append(GUIDGenerator.toHex(System.identityHashCode(this), 8));
        this.hostAndSystemID = buffer.toString();
    }

    public static GUIDGenerator getInstance(String seederClassName) {
        GUIDGenerator instance = null;
        instance = (GUIDGenerator)instances.get(seederClassName);
        if (instance == null) {
            try {
                Random seeder = (Random)Class.forName(seederClassName).newInstance();
                instance = new GUIDGenerator(seeder);
                instances.put(seederClassName, instance);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static GUIDGenerator getInstance() {
        return GUIDGenerator.getInstance(kDefaultSeeder);
    }

    public String generateKey() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(GUIDGenerator.toHex((int)(MasterClock.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL), 8));
        buffer.append(this.hostAndSystemID);
        buffer.append(GUIDGenerator.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    private static String toHex(int value, int length) {
        StringBuffer buffer = new StringBuffer(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(kcharsHexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            int b = bytes[i] & 0xFF;
            value |= b;
        }
        return value;
    }

    public boolean fromSameHost(String guidString) {
        String guidHostAndId = guidString.substring(8, 24);
        return guidHostAndId.equals(this.hostAndSystemID);
    }
}

