/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.filefilter;

import com.wily.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.util.List;

public class NameFileFilter
extends AbstractFileFilter {
    private String[] names;

    public NameFileFilter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name must not be null");
        }
        this.names = new String[]{name};
    }

    public NameFileFilter(String[] names) {
        if (names == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = names;
    }

    public NameFileFilter(List names) {
        if (names == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = names.toArray(new String[names.size()]);
    }

    public boolean accept(File file) {
        String name = file.getName();
        int i = 0;
        while (i < this.names.length) {
            if (name.equals(this.names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File file, String name) {
        int i = 0;
        while (i < this.names.length) {
            if (name.equals(this.names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

