/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.extension.IJarFile;
import com.wily.util.extension.InMemoryJarClassLoader;
import com.wily.util.extension.InMemoryJarFile;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

final class JarURLPhysicalModule {
    private static final URL[] kZeroLengthURLArray = new URL[0];
    private final URL fTargetURL;
    private final String fParent;
    private final String fProtocol;
    private final Manifest fManifest;
    private final URL[] fClassPath;
    private final URL[] fClassPathIncludingSelf;

    JarURLPhysicalModule(URL url) throws IOException, MalformedURLException {
        this.fProtocol = url.getProtocol();
        this.fTargetURL = JarURLPhysicalModule.getJarURL(url);
        this.fParent = JarURLPhysicalModule.getParentURLString(this.fTargetURL.toString());
        this.fManifest = this.findManifest();
        this.fClassPath = this.computeClassPath();
        this.fClassPathIncludingSelf = this.computeClassPathWithSelf();
    }

    final URL[] getClassPath() {
        return this.fClassPath;
    }

    final URL[] getClassPathIncludingSelf() {
        return this.fClassPathIncludingSelf;
    }

    final URL getURL() {
        return this.fTargetURL;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ClassLoader getBundleClassLoaders(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader, IJarFile jarFile) {
        classPathString = jarFile.getMainAttributes().getValue("Bundle-ClassPath");
        if (StringUtils.isEmpty(classPathString) != false) return parentClassLoader;
        memFile = null;
        tokenizer = new StringTokenizer(classPathString, ",");
        while (true) {
            if (!tokenizer.hasMoreTokens()) {
                if (memFile == null) return parentClassLoader;
                return new InMemoryJarClassLoader(parentClassLoader, memFile);
            }
            classpath = tokenizer.nextToken().trim();
            if (!classpath.endsWith(".jar")) continue;
            jarStream = null;
            try {
                try {
                    block11: {
                        jarStream = new JarInputStream(jarFile.getInputStream(classpath));
                        if (memFile != null) break block11;
                        memFile = new InMemoryJarFile(jarStream);
                        ** GOTO lbl-1000
                    }
                    memFile.appendJarFile(jarStream);
                }
                catch (IOException e) {
                    feedback.error(e.toString());
                    feedback.verbose(e);
                }
                catch (ClassNotFoundException e) {
                    feedback.error(e.toString());
                    feedback.verbose(e);
                }
            }
            catch (Throwable var10_13) {
                var9_11 = null;
                if (jarStream == null) throw var10_13;
                try {
                    jarStream.close();
                    throw var10_13;
                }
                catch (IOException e) {
                    feedback.error(e.toString());
                    feedback.debug(e);
                }
                throw var10_13;
            }
lbl-1000:
            // 4 sources

            {
                var9_11 = null;
                if (jarStream == null) continue;
            }
            try {}
            catch (IOException e) {
                feedback.error(e.toString());
                feedback.debug(e);
                continue;
            }
            jarStream.close();
            continue;
            break;
        }
    }

    public String toString() {
        return this.getURL().toString();
    }

    private Manifest findManifest() throws IOException {
        JarURLConnection conn = (JarURLConnection)this.fTargetURL.openConnection();
        conn.connect();
        Manifest manifest = conn.getManifest();
        if (manifest == null && (manifest = JarURLPhysicalModule.getManifestFromJarFile(conn.getJarFile())) == null) {
            throw new IOException("manifest not found");
        }
        Assertion.wilyAssert(manifest != null);
        return manifest;
    }

    public Manifest getManifest() {
        Assertion.wilyAssert(this.fManifest != null);
        return this.fManifest;
    }

    private URL[] computeClassPath() throws MalformedURLException {
        URL[] result;
        Manifest manifest = this.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPathString = mainAttributes.getValue("Class-Path");
        if (classPathString == null) {
            result = kZeroLengthURLArray;
        } else {
            Collection urlBag = JarURLPhysicalModule.getStringClassPathElementsAsURLCollection(JarURLPhysicalModule.getStringTokensAsArray(classPathString, " "), this.fParent, this.fProtocol);
            result = urlBag.toArray(kZeroLengthURLArray);
        }
        return result;
    }

    private URL[] computeClassPathWithSelf() {
        ArrayList<URL> completeList = new ArrayList<URL>();
        completeList.add(this.getURL());
        List<URL> deepList = Arrays.asList(this.getClassPath());
        completeList.addAll(deepList);
        return completeList.toArray(kZeroLengthURLArray);
    }

    private static final Collection getStringClassPathElementsAsURLCollection(String[] paths, String parent, String protocol) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        int x = 0;
        int y = paths.length;
        while (x < y) {
            String path = paths[x];
            URL url = null;
            try {
                url = new URL(JarURLPhysicalModule.getJarURLString(path));
            }
            catch (MalformedURLException malformedURLException) {
                url = ExtendedFile.isAbsolutePath(path) ? new URL(JarURLPhysicalModule.getJarURLString(String.valueOf(protocol) + ":/" + path)) : new URL(JarURLPhysicalModule.getJarURLString(String.valueOf(parent) + "/" + path));
            }
            try {
                url.openConnection().getContentType();
                list.add(url);
            }
            catch (IOException iOException) {}
            ++x;
        }
        return list;
    }

    private static final Manifest getManifestFromJarFile(JarFile jar) throws IOException {
        Enumeration<JarEntry> e = jar.entries();
        JarEntry entry = null;
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            return new Manifest(jar.getInputStream(entry));
        }
        return null;
    }

    public static final String getParentURLString(String url) {
        url = url.substring(0, url.lastIndexOf(33));
        url = url.substring(0, url.lastIndexOf(47));
        return url;
    }

    public static final URL getJarURL(URL url) throws MalformedURLException {
        return new URL(JarURLPhysicalModule.getJarURLString(url.toString()));
    }

    public static final String getJarURLString(String urlString) {
        if (!urlString.startsWith("jar:")) {
            urlString = "jar:" + urlString;
        }
        if (urlString.indexOf(33) == -1) {
            urlString = String.valueOf(urlString) + "!/";
        }
        return urlString;
    }

    private static final String[] getStringTokensAsArray(String list, String token) {
        StringTokenizer strTok = new StringTokenizer(list, token);
        String[] array = new String[strTok.countTokens()];
        int x = 0;
        while (x < array.length) {
            array[x] = strTok.nextToken().trim();
            ++x;
        }
        return array;
    }
}

