/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.KConstants;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.net.URI;
import java.util.Map;

public abstract class BaseHttpBackendTracer
extends BackendTracer
implements IInvocationDataParameterCallback {
    protected HttpDataResolver dataResolver;
    protected IModuleFeedbackChannel feedback;
    private static final Module module = new Module("BaseHttpBackendTracer");
    private final IAgent agent;
    private ReentrancyLevel reentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private final VirtualStack virtualStack;

    public BaseHttpBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.feedback = this.getAgent().IAgent_getModuleFeedback();
        this.dataResolver = this.getDataResolver();
        this.virtualStack = new VirtualStack(agent);
    }

    protected abstract HttpDataResolver getDataResolver();

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            URI uriObject = null;
            if (this.dataResolver != null) {
                uriObject = this.dataResolver.getUri(this.agent, data);
                if (uriObject != null && uriObject != KConstants.UNKNOWN_URI) {
                    int port = uriObject.getPort();
                    if (port == 80 || port == 443) {
                        data.put("HttpURI.Url.TT.Key", (Object)UrlUtilities.buildUrlString(uriObject, false));
                    } else {
                        data.put("HttpURI.Url.TT.Key", (Object)uriObject.toString());
                    }
                    data.put("HttpURI.Key", (Object)uriObject);
                } else if (uriObject == KConstants.UNKNOWN_URI) {
                    data.put("HttpURI.Url.TT.Key", (Object)"Unknown");
                }
                String httpMethod = this.dataResolver.getHttpMethod(this.agent, data);
                if (httpMethod != null && httpMethod.length() != 0) {
                    data.put("HttpURI.Method.Key", (Object)httpMethod);
                } else {
                    data.put("HttpURI.Method.Key", (Object)"Unknown");
                }
                data.setParameterCallback((IInvocationDataParameterCallback)this);
            }
        }
        catch (Exception ex) {
            this.feedback.error(module, "ITracer_startTrace - unable to resolve URI or Http Method");
            this.feedback.verbose((Throwable)ex);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        try {
            InvocationData data = (InvocationData)elementData;
            if (!data.hasInvocationThrownException() || this.showStatusCodeIfExceptionThrown()) {
                this.handleStatusCodeAndError(data, elementData);
            }
        }
        catch (ClassCastException castException) {
            this.feedback.error(module, "doOnEndTrace - expected \"elementData\" to be an instance of InvocationData");
            this.feedback.verbose((Throwable)castException);
        }
        super.doOnEndTrace(tracerIndex, elementData, element);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String url = (String)data.get("HttpURI.Url.TT.Key");
        String httpMethod = (String)data.get("HttpURI.Method.Key");
        if (url != null) {
            parameters.put("Called URL", this.getRawURL(url));
        }
        if (httpMethod != null) {
            parameters.put("HTTP Method", httpMethod);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.reentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.hasAnotherBackend();
    }

    protected boolean hasAnotherBackend() {
        return VirtualStack.staticHasEndBoundary();
    }

    protected boolean generateErrorForErrorStatusCode() {
        return true;
    }

    protected boolean showStatusCodeIfExceptionThrown() {
        return false;
    }

    protected String getRawURL(String url) {
        return url;
    }

    private void handleStatusCodeAndError(InvocationData data, IStackElement stackElement) {
        if (this.dataResolver == null) {
            return;
        }
        int statusCode = this.dataResolver.getHttpStatusCode(this.agent, data);
        if (statusCode == -1) {
            return;
        }
        String statusMessage = this.dataResolver.getHttpStatusMessage(this.agent, data);
        String responseCode = String.valueOf(Integer.toString(statusCode)) + " - " + statusMessage;
        if (statusCode >= 400 && statusCode <= 599 && this.generateErrorForErrorStatusCode()) {
            ErrorFeature.incrementErrorMetric((IStackElement)data);
            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)responseCode);
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)responseCode, (IAgent)this.getAgent());
        }
        this.virtualStack.IBlameStack_addExtraParameter("HTTP Status Code", responseCode, stackElement);
    }
}

